/**
 * 出库任务分配信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.outstock.OutstockTaskEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'outstock.OutstockTaskEditView'
	],
	stores:[
	    'WMS.store.outstock.OutstockDemandBillItemGoodsViewStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'outstocktaskeditview  button[name=btn-save]': {
				click: this.onSave
			},
			//打印按钮事件
			'outstocktaskeditview  button[name=btn-print]': {
				click: this.onPrint
			},
			'outstocktaskeditview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	OnBeforeShow : function(win, e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'outstock/searchOutstockDemandBillItemList.action',
			params: {outstockDemandBillId: win.oldOutstockDemandBillId}
		});
		
		//刷新出库组下拉框数据
		win.down('combobox[name=outstockGroup]').getStore().reload();
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		if(null == store || undefined == store || 0 == store.getCount()) {
			ACBEE.Ext.Util.showAlertBox("请添加至少一条货物明细", null, 300);
			return false;
		}
		var outstockTactics;
		var actualArrivalQuantity;
		//货物号与生产批号拼接的字符串
		var goodsLinkProductBatch = "";
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			outstockTactics = store.getAt(i).get('outstockTactics');
			if(null == outstockTactics) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的出库策略不能为空", null, 300);
				return false;
			}
			actualOutstockTotalQuantity = store.getAt(i).get('actualOutstockTotalQuantity');
				if(null == actualOutstockTotalQuantity) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的总出库数量不能为空", null, 300);
				return false;
			}
		}
		return true;
	},
	//打印按钮事件
	onPrint : function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		ACBEE.Ext.Util.showReport({
			report: 'outstockBill',
			outstockDemandBillId: win.oldOutstockDemandBillId
		});
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}

		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}

		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldOutstockDemandBillId=win.oldOutstockDemandBillId;
		
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'outstockBill/saveOutstockBill.action', {
			oldOutstockDemandBillId : oldOutstockDemandBillId,
			goods : goods,
		}, "出库任务分配成功", "出库任务分配失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});