/**
 * 出库任务分配信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.outstock.OutstockTaskSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'outstock.OutstockTaskSearchView'
	],
	requires: [
	    'WMS.view.outstock.OutstockTaskEditView',
	    'WMS.controller.outstock.OutstockTaskEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'outstocktasksearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//查询按钮事件
	    	'outstocktasksearchview button[name=btn-search]': {
	    		click: this.onSearchOutstockDemandBill
	    	},
	    	//清空按钮事件
	    	'outstocktasksearchview button[name=btn-clear]': {
	    		click: this.onClearOutstockDemandBill
	    	},
	    	//表格事件
	    	'outstocktasksearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新需方商下拉框数据
    	grid.down('combobox[name=demanderId]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载需方商下拉框数据
		var demanderCbx = form.down('combobox[name=demanderId]');
		var demanderStore = demanderCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的需方商
			//修改需方商store参数
			demanderStore.proxy.extraParams = {
				status: 1
			};
		}else{
			//修改需方商store参数
			demanderStore.proxy.extraParams = {
				status: -1
			};
		}
		//重加载需方商下拉框数据
		demanderStore.load();
		
		//显示禁用项改变时，需方商改为空
		if(showForbidden != null){
			demanderCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchOutstockDemandBill(combobox);
	},
	//查询按钮事件处理
	onSearchOutstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var outstockTaskSearchGrid = button.up('grid');
		//取得表单对象
		var form = outstockTaskSearchGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得出库需求号
		var demandNo = outstockTaskSearchGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(outstockTaskSearchGrid.down('datefield[name=outstockBillBeginDate]').getValue()==null)
			var outstockBillBeginDate=null;
	    else
		    outstockBillBeginDate = Ext.Date.format(new Date(outstockTaskSearchGrid.down('datefield[name=outstockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(outstockTaskSearchGrid.down('datefield[name=outstockBillEndDate]').getValue()==null)
			var outstockBillEndDate=null;
	    else    
		    outstockBillEndDate = Ext.Date.format(new Date(outstockTaskSearchGrid.down('datefield[name=outstockBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划出库开始时间
		if(outstockTaskSearchGrid.down('datetimefield[name=planOutstockBillBeginDate]').getValue()==null)
	    	var planOutstockBillBeginDate=null;
	    else
			planOutstockBillBeginDate = Ext.Date.format(new Date(outstockTaskSearchGrid.down('datetimefield[name=planOutstockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得计划出库结束时间
	    if(outstockTaskSearchGrid.down('datetimefield[name=planOutstockBillEndDate]').getValue()==null)
    		var planOutstockBillEndDate=null;
    	else
			planOutstockBillEndDate = Ext.Date.format(new Date(outstockTaskSearchGrid.down('datetimefield[name=planOutstockBillEndDate]').getValue()),'Y-m-d H:i:s');
        //取得订单号
		var orderNo = outstockTaskSearchGrid.down('textfield[name=orderNo]').getValue();
        //取得需方商
		var demanderId = outstockTaskSearchGrid.down('combobox[name=demanderId]').getValue();
		//取得分配状态
		var status = outstockTaskSearchGrid.down('combobox[name=status]').getValue();
	    //取得显示禁用项
	    var showForbidden=outstockTaskSearchGrid.down('checkbox[name=showForbidden]').getValue();
		
		//取得退库需求单的store
		var store = outstockTaskSearchGrid.getStore();
		
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			orderNo : orderNo,
			demanderId : demanderId,
			status : status,
			outstockBillBeginDate : outstockBillBeginDate,
			outstockBillEndDate : outstockBillEndDate,
			planOutstockBillBeginDate : planOutstockBillBeginDate,
			planOutstockBillEndDate : planOutstockBillEndDate,
			demanderStatus: showForbidden ? -1 : 1
		};
		store.loadPage(1);
	},
	//清空按钮事件
	onClearOutstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var outstockTaskSearchGrid = button.up('grid');
		///清空查询条件
		outstockTaskSearchGrid.down('textfield[name=demandNo]').setValue('');
		outstockTaskSearchGrid.down('textfield[name=orderNo]').setValue('');
		outstockTaskSearchGrid.down('datefield[name=outstockBillBeginDate]').setValue('');
		outstockTaskSearchGrid.down('datefield[name=outstockBillEndDate]').setValue('');
		outstockTaskSearchGrid.down('datetimefield[name=planOutstockBillBeginDate]').setValue('');
	    outstockTaskSearchGrid.down('datetimefield[name=planOutstockBillEndDate]').setValue('');
		outstockTaskSearchGrid.down('combobox[name=demanderId]').setValue('');
		outstockTaskSearchGrid.down('combobox[name=status]').setValue('-1');
		outstockTaskSearchGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchOutstockDemandBill(button);
	},
	//任务分配
	onOutstockTask :function(grid, record){
		//加载出库任务分配编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "outstock.OutstockTaskEditCtl");
		//显示出库任务分配window
		var win = ACBEE.Ext.Util.getWin('outstocktaskeditview');
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	//保存出库单Id
	  	win.oldOutstockDemandBillId=record.data.outstockDemandBillId;
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('任务分配 [' + record.get('demandNo') + ']');
		//判断出库状态，为未出库则可以修改，否则不可以修改
		var outstockStatus;
		ACBEE.Ext.Util.ajaxRequest("outstockBill/outstockStatus.action",{oldOutstockDemandBillId : win.oldOutstockDemandBillId},function(result){
  			outstockStatus = result.map.outstockStatus;
	  	});
	    if(outstockStatus != 0 && win.down('form').down('combobox[name=outstockGroup]').getValue()!=null){
	    	var save=win.down('button[name=btn-save]');
			ACBEE.Ext.Util.disableCompoment([save], win.down('form'), true);
			win.outstockStatus = outstockStatus;
	    }
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(14 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-tasking')) {//点击了任务分配
				this.onOutstockTask(grid, record);
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('tasking')) {
			this.onOutstockTask(grid, record);
		}
	}
});