/**
 * 货期报表管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.report.FutureInventorySearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'report.FutureInventorySearchView'
	],
	statics:{
		beginDate : '',
		endDate : ''
   	},
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//供应商改变事件
	    	'futureinventorysearchview combobox[name=supplierName]': {
	    		change: this.onSupplierNameChange
	    	},
	    	//货物号改变事件
	    	'futureinventorysearchview combobox[name=goodsCode]': {
	    		change: this.onGoodsCodeChange
	    	},
	    	//品名改变事件
	    	'futureinventorysearchview combobox[name=goodsName]': {
	    		change: this.onGoodsNameChange
	    	},
	    	//库区名称改变事件
	    	'futureinventorysearchview combobox[name=areaName]': {
	    		change: this.onAreaNameChange
	    	},
	    	//查询按钮事件
	    	'futureinventorysearchview button[name=btn-search]': {
	    		click: this.onSearchFutureInventory
	    	},
	    	//重置按钮事件
	    	'futureinventorysearchview button[name=btn-clear]': {
	    		click: this.onClearFutureInventory
	    	},
	    	//导出按钮事件
	    	'futureinventorysearchview button[name=btn-export]': {
	    		click: this.onExportStockReport
	    	},
	    	//表格事件
	    	'futureinventorysearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	//刷新库位性质下拉框数据
    	grid.down('combobox[name=natureId]').getStore().reload();
    	//刷新库区名称下拉框数据
    	grid.down('combobox[name=areaName]').getStore().reload();
    	//刷新库位下拉框数据
    	grid.down('combobox[name=locationNo]').getStore().reload();
    	//刷新货物编号下拉框数据
    	grid.down('combobox[name=goodsCode]').getStore().reload();
    	//刷新货物名称下拉框数据
    	grid.down('combobox[name=goodsName]').getStore().reload();
    },
	/**
	 * 供应商改变事件
	 */
    onSupplierNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到供应商Id值
		var supplierId = combobox.getValue();
		
		///1. 根据供应商Id值重新加载货物号和品名下拉框数据
		var goodsCodeCbx = form.down('combobox[name=goodsCode]');
		var goodsNameCbx = form.down('combobox[name=goodsName]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var goodsCodeStore = goodsCodeCbx.getStore();
		var goodsNameStore = goodsNameCbx.getStore();
		//修改货物号store参数
		goodsCodeStore.proxy.extraParams = {
			supplierId: supplierId,
			goodsId: -1,
    	 	status: -1
		};
		//重加载货物号下拉框数据
		goodsCodeStore.load();

		//修改品名store参数
		goodsNameStore.proxy.extraParams = {
			supplierId: supplierId,
			goodsId: -1,
    	 	status: -1
		};
		//重加载品名下拉框数据
		goodsNameStore.load();
		
		//供应商改变时，货物号改为全部，品名改为全部
		if(supplierId != null){
			goodsCodeCbx.setValue('');
			goodsNameCbx.setValue(-1);
		}
	},
	/**
	 * 货物号改变事件
	 */
	onGoodsCodeChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到货物Id值
		var goodsId = combobox.getValue();
		var supplierId = form.down('combobox[name=supplierName]').getValue();
		
		///1. 根据货物Id值重新加载品名下拉框数据
		var goodsNameCbx = form.down('combobox[name=goodsName]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var goodsNameStore = goodsNameCbx.getStore();

		//修改品名store参数
		goodsNameStore.proxy.extraParams = {
			supplierId:supplierId,
			goodsId: goodsId,
			status: -1
		};
		//重加载品名下拉框数据
		goodsNameStore.load();
		var goodsName = form.down('combobox[name=goodsName]').getValue();
		
		//货物号改变时，品名改为全部
		if(goodsName == -1){
			goodsNameCbx.setValue(-1);
		}
	},
	/**
	 * 品名改变事件
	 */
	onGoodsNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到货物Id值
		var goodsId = combobox.getValue();
		var supplierId = form.down('combobox[name=supplierName]').getValue();
		
		///1. 根据货物Id值重新加载品名下拉框数据
		var goodsCodeCbx = form.down('combobox[name=goodsCode]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var goodsCodeStore = goodsCodeCbx.getStore();

		//修改品名store参数
		goodsCodeStore.proxy.extraParams = {
			supplierId:supplierId,
			goodsId: goodsId,
			status: -1
		};
		//重加载品名下拉框数据
		goodsCodeStore.load();
		var goodsCode = form.down('combobox[name=goodsCode]').getValue();
		//货物号改变时，品名改为全部
		if(goodsCode == -1){
			goodsCodeCbx.setValue(-1);
		}
	},
	
	//库区名称改变事件
	onAreaNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var areaId = combobox.getValue();
		var locationNoCbx = form.down('combobox[name=locationNo]');
		//当库区名称改变时，库位号为全部
		if(areaId != null){
			locationNoCbx.setValue('');
		}
		
		//取得库区性质值
		var locationStore = locationNoCbx.getStore();
		//修改库位号store参数
		locationStore.proxy.extraParams = {
			areaId: areaId,
			areaNature: -1,
		 	status : -1
		};
		//重加载库位号下拉框数据
		locationStore.load();
	},

	//查询按钮事件处 理
	onSearchFutureInventory:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到按钮所在的表格
		var grid = button.up('grid');
		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}

		/*if(grid.down('datefield[name=endDate]').getValue()==null){
			ACBEE.Ext.Util.showAlertBox("请填写结束日期，确定期限的结束", null, 300);
		}
		
		if(grid.down('datefield[name=beginDate]').getValue()==null){
			ACBEE.Ext.Util.showAlertBox("请填写开始日期，确定期限的开始", null, 300);
		}*/

		
		
		//获取查询条件
		//取得开始时间
	    if(grid.down('datefield[name=beginDate]').getValue()==null)
	    	WMS.controller.report.FutureInventorySearchCtl.beginDate = "";
	    else
	    	WMS.controller.report.FutureInventorySearchCtl.beginDate = Ext.Date.format(new Date(grid.down('datefield[name=beginDate]').getValue()),'Y-m-d H:i:s');
	    
	    //取得结束时间
	    if(grid.down('datefield[name=endDate]').getValue()==null)
	    	WMS.controller.report.FutureInventorySearchCtl.endDate="";
	    else
	    	WMS.controller.report.FutureInventorySearchCtl.endDate=Ext.Date.format(new Date(grid.down('datefield[name=endDate]').getValue()),'Y-m-d H:i:s');
	    //取得供应商ID
	    var supplierId=grid.down('combobox[name=supplierName]').getValue();
	    //取得库区ID
	    var areaId=grid.down('combobox[name=areaName]').getValue();
	    //取得库位ID
	    var locationId=grid.down('combobox[name=locationNo]').getValue();
	    //取得库位性质ID
	    var natureId=grid.down('combobox[name=natureId]').getValue();
		//货物号1
	    var goodsCodeId=grid.down('textfield[name=goodsCode]').getValue();
		//品名
	    var goodsNameId=grid.down('textfield[name=goodsName]').getValue();
	  //设置查询参数
		grid.getStore().proxy.extraParams = {
        	beginDate: WMS.controller.report.FutureInventorySearchCtl.beginDate,
        	endDate: WMS.controller.report.FutureInventorySearchCtl.endDate,
        	supplierId: supplierId,
        	areaId: areaId,
        	locationId: locationId,
        	natureId:natureId,
			goodsId: goodsCodeId == -1 ? (goodsNameId == -1 ? -1 : goodsNameId) : goodsCodeId
		};
		//重新加载store
		grid.getStore().loadPage(1);
	},
	//重置按钮事件
	onClearFutureInventory:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//重置查询条件
		grid.down('datefield[name=beginDate]').setValue('');
	    grid.down('datefield[name=endDate]').setValue('');
		grid.down('combobox[name=supplierName]').setValue('');
		grid.down('combobox[name=areaName]').setValue('');
		grid.down('combobox[name=locationNo]').setValue('');
		grid.down('combobox[name=natureId]').setValue(-1);
		grid.down('combobox[name=goodsCode]').setValue('');
		grid.down('combobox[name=goodsName]').setValue(-1);
		//调用查询按钮事件
		this.onSearchFutureInventory(button);
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {

		this.onUpdate(grid, record);
			
	},
	onUpdate:function (grid,record){
		//加载入库需求单编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "report.FutureInventoryEditCtl");
		//显示入库需求单window
		var win = ACBEE.Ext.Util.getWin('futureinventoryeditview');
		//保存当前表格的store
	   
	   
	  	win.parentStore=grid.getStore();
	  	win.goodsId = record.data.goodsId;
	  	win.supplierId = record.data.supplierId;
	  	win.locationId = record.data.locationId;
		//win.beginDate = WMS.controller.report.FutureInventorySearchCtl.beginDate;
		//win.endDate = WMS.controller.report.FutureInventorySearchCtl.endDate;
	  	//将选中记录的数据装载到窗口中
		win.down('form').loadRecord(record);
		win.show();
	},
	//导出按钮事件
	onExportStockReport:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//导出库存报表信息
		ACBEE.Ext.Util.exportExcelFile(grid, "期初期末报表");
	}
});