/**
 * 库存报表管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.report.StockReportSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'report.StockReportSearchView'
	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//供应商改变事件
	    	'stockreportsearchview combobox[name=supplierName]': {
	    		change: this.onSupplierNameChange
	    	},
	    	//货物号改变事件
	    	'stockreportsearchview combobox[name=goodsCode]': {
	    		change: this.onGoodsCodeChange
	    	},
	    	//库区名称改变事件
	    	'stockreportsearchview combobox[name=areaName]': {
	    		change: this.onAreaNameChange
	    	},
	    	//品名改变事件
	    	'stockreportsearchview combobox[name=goodsName]': {
	    		change: this.onGoodsNameChange
	    	},
	    	//查询按钮事件
	    	'stockreportsearchview button[name=btn-search]': {
	    		click: this.onSearchStockReport
	    	},
	    	//导出按钮事件
	    	'stockreportsearchview button[name=btn-export]': {
	    		click: this.onExportStockReport
	    	},
	    	//重置按钮事件
	    	'stockreportsearchview button[name=btn-clear]': {
	    		click: this.onClearStockReport
	    	},
	    	//表格事件
	    	'stockreportsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	//刷新库位性质下拉框数据
    	grid.down('combobox[name=natureId]').getStore().reload();
    	//刷新库区名称下拉框数据
    	grid.down('combobox[name=areaName]').getStore().reload();
    	//刷新库位下拉框数据
    	grid.down('combobox[name=locationNo]').getStore().reload();
    	//刷新货物编号下拉框数据
    	grid.down('combobox[name=goodsCode]').getStore().reload();
    	//刷新货物名称下拉框数据
    	grid.down('combobox[name=goodsName]').getStore().reload();
    	
    },
	/**
	 * 供应商改变事件
	 */
    onSupplierNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到供应商Id值
		var supplierId = combobox.getValue();
		
		///1. 根据供应商Id值重新加载货物号和品名下拉框数据
		var goodsCodeCbx = form.down('combobox[name=goodsCode]');
		var goodsNameCbx = form.down('combobox[name=goodsName]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var goodsCodeStore = goodsCodeCbx.getStore();
		var goodsNameStore = goodsNameCbx.getStore();
		//修改货物号store参数
		goodsCodeStore.proxy.extraParams = {
			supplierId: supplierId,
			goodsId: -1,
    	 	status: -1
		};
		//重加载货物号下拉框数据
		goodsCodeStore.load();

		//修改品名store参数
		goodsNameStore.proxy.extraParams = {
			supplierId: supplierId,
			goodsId: -1,
    	 	status: -1
		};
		//重加载品名下拉框数据
		goodsNameStore.load();
		
		//供应商改变时，货物号改为全部，品名改为全部
		if(supplierId != null){
			goodsCodeCbx.setValue('');
			goodsNameCbx.setValue(-1);
		}
	},
	/**
	 * 货物号改变事件
	 */
	onGoodsCodeChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到货物Id值
		var goodsId = combobox.getValue();
		
		///1.  根据货物Id值重新加载品名下拉框数据
		var goodsNameCbx = form.down('combobox[name=goodsName]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var goodsNameStore = goodsNameCbx.getStore();

		//修改品名store参数
		goodsNameStore.proxy.extraParams = {
			goodsId: goodsId,
			goodsId: goodsId,
			status: -1
		};
		//重加载品名下拉框数据
		goodsNameStore.load();
		var goodsName = form.down('combobox[name=goodsName]').getValue();
		
		//货物号改变时，品名改为全部
		if(goodsName == -1){
			goodsNameCbx.setValue(-1);
		}
	},
	/**
	 * 品名改变事件
	 */
	onGoodsNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到货物Id值
		var goodsId = combobox.getValue();
		var supplierId = form.down('combobox[name=supplierName]').getValue();
		
		///1. 根据货物Id值重新加载品名下拉框数据
		var goodsCodeCbx = form.down('combobox[name=goodsCode]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var goodsCodeStore = goodsCodeCbx.getStore();

		//修改品名store参数
		goodsCodeStore.proxy.extraParams = {
				supplierId:supplierId,
				goodsId: goodsId,
				status: -1
		};
		//重加载品名下拉框数据
		goodsCodeStore.load();
		var goodsCode = form.down('combobox[name=goodsCode]').getValue();
		//货物号改变时，品名改为全部
		if(goodsCode == -1){
			goodsCodeCbx.setValue(-1);
		}
	},
	
	//库区名称改变事件
	onAreaNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var areaId = combobox.getValue();
		var locationNoCbx = form.down('combobox[name=locationNo]');
		//当库区名称改变时，库位号为全部
		if(areaId != null){
			locationNoCbx.setValue('');
		}
		
		//取得库区性质值
		var locationStore = locationNoCbx.getStore();
		//修改库位号store参数
		locationStore.proxy.extraParams = {
			areaId: areaId,
			areaNature: -1,
		 	status : -1
		};
		//重加载库位号下拉框数据
		locationStore.load();
	},
	//查询按钮事件处理
	onSearchStockReport:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到按钮所在的表格
		var grid = button.up('grid');
		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获取查询条件
		//取得开始时间
	    var beginDateTime = "";
	    if(grid.down('datetimefield[name=beginDateTime]').getValue()==null)
	    	beginDateTime = "";
	    else
	    	beginDateTime= Ext.Date.format(new Date(grid.down('datetimefield[name=beginDateTime]').getValue()),'Y-m-d H:i:s');
	    //取得结束时间
	    var endDateTime = "";
	    if(grid.down('datetimefield[name=endDateTime]').getValue()==null)
	    	var endDateTime="";
	    else
	    	endDateTime=Ext.Date.format(new Date(grid.down('datetimefield[name=endDateTime]').getValue()),'Y-m-d H:i:s');
	    //取得供应商ID
	    var supplierId=grid.down('combobox[name=supplierName]').getValue();
	    //取得库区ID
	    var areaId=grid.down('combobox[name=areaName]').getValue();
	    //取得库位ID
	    var locationId=grid.down('combobox[name=locationNo]').getValue();
	    //取得库位性质ID
	    var natureId=grid.down('combobox[name=natureId]').getValue();
		//货物号1
	    var goodsCodeId=grid.down('textfield[name=goodsCode]').getValue();
		//品名
	    var goodsNameId=grid.down('textfield[name=goodsName]').getValue();
	  //设置查询参数
		grid.getStore().proxy.extraParams = {
        	beginDateTime: beginDateTime,
        	endDateTime: endDateTime,
        	supplierId: supplierId,
        	areaId: areaId,
        	locationId: locationId,
        	natureId:natureId,
			goodsId: goodsCodeId == -1 ? (goodsNameId == -1 ? -1 : goodsNameId) : goodsCodeId
		};
		//重新加载store
		grid.getStore().loadPage(1);
	},
	//重置按钮事件
	onClearStockReport:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//重置查询条件
		grid.down('datefield[name=beginDateTime]').setValue('');
	    grid.down('datefield[name=endDateTime]').setValue('');
		grid.down('combobox[name=supplierName]').setValue('');
		grid.down('combobox[name=areaName]').setValue('');
		grid.down('combobox[name=locationNo]').setValue('');
		grid.down('combobox[name=natureId]').setValue(-1);
		grid.down('combobox[name=goodsCode]').setValue('');
		grid.down('combobox[name=goodsName]').setValue(-1);
		//调用查询按钮事件
		this.onSearchStockReport(button);
	},
	
	
	
	//导出按钮事件
	onExportStockReport:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//导出库存报表信息
		this.exportStockReportExcelFile(grid, "库存报表信息");
	},
	/**
	 * 将grid数据导出excel文件
	 * @param grid 要导出数据的grid
	 * @param fileName	导出的excel文件名
	 * @param ignoreFields 需要忽略的字段数组
	 */
	exportStockReportExcelFile: function(grid, fileName, ignoreFields) {
		//封装表格数据
        var data = [];
        var store = grid.getStore();
        var d;
        store.each(function(record){
        	//格式化数据
        	record.data.volume = (record.data.outerPackingVolume*record.data.quantity);
        	record.data.totalPrice = (record.data.price*record.data.quantity);
        	record.data.weight = (record.data.outerPackingWeight*record.data.quantity);
        	d = ACBEE.Ext.Util.formatString(record.data);
        	//alert(record.data.volume);
            data.push(d);
        }, this);
        ACBEE.Ext.Util.exportGridExcelFile(grid, fileName, data, ignoreFields);
	},
});