/**
 * 操作流水信息编辑controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.stock.OperFlowSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'stock.OperFlowSearchView'
	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'operflowsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//库区性质改变事件
	    	'operflowsearchview combobox[name=areaNature]': {
	    		change: this.onAreaNatureChange
	    	},
	    	//库区名称改变事件
	    	'operflowsearchview combobox[name=areaName]': {
	    		change: this.onAreaNameChange
	    	},
	    	//操作类型改变事件
	    	'operflowsearchview combobox[name=operType]': {
	    		change: this.onOperTypeChange
	    	},
	    	//操作原因点击事件
	    	'operflowsearchview combobox[name=remark]': {
	    		expand: this.onRemarkChange
	    	},
	    	//查询按钮事件
	    	'operflowsearchview button[name=btn-search]': {
	    		click: this.onSearchOperflow
	    	},
	    	//重置按钮事件
	    	'operflowsearchview button[name=btn-clear]': {
	    		click: this.onClearOperflow
	    	},
	    	//导出按钮事件
	    	'operflowsearchview button[name=btn-export]': {
	    		click: this.onExportOperflow
	    	},
	    	//表格事件
	    	'operflowsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新库区名称下拉框数据
    	grid.down('combobox[name=areaName]').getStore().reload();
    	//刷新库位号下拉框数据
    	grid.down('combobox[name=locationNo]').getStore().reload();
    	//刷新供应商下拉框数据
    	grid.down('combobox[name=supplierName]').getStore().reload();
    	//刷新需方商下拉框数据
    	grid.down('combobox[name=demanderName]').getStore().reload();
    	//刷新操作员下拉框数据
    	grid.down('combobox[name=userId]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商、操作员、操作原因、库位号、库区名称下拉框数据
		var supplierNameCbx = form.down('combobox[name=supplierName]');
		var demanderNameCbx = form.down('combobox[name=demanderName]');
		var remarkCbx = form.down('combobox[name=remark]');
		var userCbx = form.down('combobox[name=userId]');
		var locationNoCbx = form.down('combobox[name=locationNo]');
		var areaNameCbx = form.down('combobox[name=areaName]');
		var supplierNameStore = supplierNameCbx.getStore();
		var demanderNameStore = demanderNameCbx.getStore();
		var remarkStore = remarkCbx.getStore();
		var userStore = userCbx.getStore();
		var areaNameStore = areaNameCbx.getStore();
		var locationNoStore = locationNoCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的需方商性质
			//修改供应商store参数
			supplierNameStore.proxy.extraParams = {
				status: 1
			};
			//修改需方商store参数
			demanderNameStore.proxy.extraParams = {
				status: 1	
			};
			//修改操作原因store参数
			remarkStore.proxy.extraParams = {
				dictType: -1,
				status: 1
			};
			//修改操作员store参数
			userStore.proxy.extraParams = {
				status: 1
			};
			//修改库区名称store参数
			areaNameStore.proxy.extraParams = {
				areaNature: -1,
				status: 1
			};
			//修改库位号store参数
			locationNoStore.proxy.extraParams = {
				areaId: -1,
        	 	areaNature:-1,
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierNameStore.proxy.extraParams = {
				status: -1
			};
			demanderNameStore.proxy.extraParams = {
				status: -1	
			};
			//修改操作原因store参数
			remarkStore.proxy.extraParams = {
				dictType: -1,
				status: -1
			};
			//修改操作员store参数
			userStore.proxy.extraParams = {
				status: -1
			};
			//修改库区名称store参数
			areaNameStore.proxy.extraParams = {
				areaNature: -1,
				status: -1
			};
			//修改库位号store参数
			locationNoStore.proxy.extraParams = {
				areaId: -1,
        	 	areaNature:-1,
				status: -1
			};
		}
		//重加载需方商性质下拉框数据
		supplierNameStore.load();
		demanderNameStore.load();
		remarkStore.load();
		userStore.load();
		areaNameStore.load();
		locationNoStore.load();
		
		//显示禁用项改变时，需方商性质改为全部
		if(showForbidden != null){
			supplierNameCbx.setValue();
			demanderNameCbx.setValue();
			remarkCbx.setValue(-1);
			userCbx.setValue(-1);
			locationNoCbx.setValue(-1);
			areaNameCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchOperflow(combobox);
	},
	/**
	 * 库区性质改变事件
	 */
	onAreaNatureChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区性质值
		var nature = combobox.getValue();
		
		///1. 根据库区性质重新加载库区下拉框数据
		var areaCbx = form.down('combobox[name=areaName]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var areaStore = areaCbx.getStore();
		//修改库区store参数
		areaStore.proxy.extraParams = {
			areaNature: nature,
			status: -1
		};
		//重加载库区下拉框数据
		areaStore.load();
		
		///1. 根据库区性质重新加载库位号下拉框数据
		var locationNoCbx = form.down('combobox[name=locationNo]');
		var locationStore = locationNoCbx.getStore();
		//修改库位号store参数
		locationStore.proxy.extraParams = {
			areaId: -1,
			areaNature: nature,
		 	status : -1
		};
		//重加载库位号下拉框数据
		locationStore.load();
		
		//库区性质改变时，库区名称改为全部，库位号改为全部
		if(nature != null){
			areaCbx.setValue(-1);
			locationNoCbx.setValue(-1);
		}
	},
	//库区名称改变事件 
	onAreaNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var areaId = combobox.getValue();
		var locationNoCbx = form.down('combobox[name=locationNo]');
		//当库区名称改变时，库位号为全部
		if(areaId != null){
			locationNoCbx.setValue(-1);
		}
		
		//取得库区性质值
		var areaNature = form.down('combobox[name=areaNature]').getValue();
		var locationStore = locationNoCbx.getStore();
		//修改库位号store参数
		locationStore.proxy.extraParams = {
			areaId: areaId,
			areaNature: areaNature,
		 	status : -1
		};
		//重加载库位号下拉框数据
		locationStore.load();
	},
	//操作类型改变事件
	onOperTypeChange: function(combobox, record, value){
		//得到操作类型值
		var operType = combobox.getValue();
		var remarkCbx = combobox.up('form').down('combobox[name=remark]');
		if(operType != null){
			remarkCbx.setValue(-1);
		}
		
		var remarkStore = remarkCbx.getStore();
		//修改操作原因store参数
		remarkStore.proxy.extraParams = {
			dictType: operType,
			status: -1
		};
		//重加载操作原因下拉框数据
		remarkStore.load();
	},
	//操作原因改变事件
	onRemarkChange: function(combobox, record, value){
		//得到操作原因值
		var remark = combobox.getValue();
		var remarkCbx = combobox.up('form').down('combobox[name=remark]');
		var remarkStore = remarkCbx.getStore();
		if(remarkStore.data.keys.length == 1){
			ACBEE.Ext.Util.showAlertBox("请先选择操作类型，再选择操作原因！", null, 320);
			return false;
		}
		//重加载操作原因下拉框数据
		remarkStore.load();
	},
	/**
	 * 查询或导出帐套流水信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportOperflow: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		///取得查询条件
		//货物号
	    var goodsCode=grid.down('textfield[name=goodsCode]').getValue();
	    //取得库区性质
	    var areaNature=grid.down('combobox[name=areaNature]').getValue();
	    //取得库区ID
	    var areaId=grid.down('combobox[name=areaName]').getValue();
	    //取得库位ID
	    var locationId=grid.down('combobox[name=locationNo]').getValue();
	    //取得供应商ID
	    var supplierId=grid.down('combobox[name=supplierName]').getValue();
	    //取得操作员ID
	    var userId=grid.down('combobox[name=userId]').getValue();
	    //取得操作类型
	    var operType=grid.down('combobox[name=operType]').getValue();
	    //取得需方商ID
	    var demanderId=grid.down('combobox[name=demanderName]').getValue();
	    //取得送货人
	    var deliveryman=grid.down('textfield[name=deliveryman]').getValue();
		//取得车辆号码
	    var vehicleNo=grid.down('textfield[name=vehicleNo]').getValue();
	    //取得操作原因ID
	    var causeId=grid.down('combobox[name=remark]').getValue();
	    //取得操作开始时间
	    var beginDateTime = "";
	    if(grid.down('datetimefield[name=beginDateTime]').getValue()==null)
	    	beginDateTime = "";
	    else
	    	beginDateTime= Ext.Date.format(new Date(grid.down('datetimefield[name=beginDateTime]').getValue()),'Y-m-d H:i:s');
	    //取得操作结束时间
	    var endDateTime = "";
	    if(grid.down('datetimefield[name=endDateTime]').getValue()==null)
	    	var endDateTime="";
	    else
	    	endDateTime=Ext.Date.format(new Date(grid.down('datetimefield[name=endDateTime]').getValue()),'Y-m-d H:i:s');
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		//取得供应商性质状态
		var supplierStatus=-1;
		//库区状态
		var areaStatus=-1;
		//操作原因状态
		var causeStatus=-1;
	    
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				goodsCode: goodsCode,
	        	operType: operType,
	        	areaNature: areaNature,
	        	areaId: areaId,
	        	locationId: locationId,
	        	supplierId: supplierId,
	        	demanderId: demanderId,
	        	causeId: causeId,
	        	beginDateTime: beginDateTime,
	        	endDateTime: endDateTime,
	        	userId:userId,
	        	deliveryman:deliveryman,
	        	vehicleNo:vehicleNo,
	        	supplierStatus: showForbidden ? supplierStatus : 1,
	        	areaStatus: showForbidden ? areaStatus : 1,
	        	causeStatus: showForbidden ? causeStatus : 1
			};
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出帐套流水信息
			ACBEE.Ext.Util.submitDummyForm("operflow/exportOperflow.action", {
				goodsCode: goodsCode,
	        	operType: operType,
	        	areaNature: areaNature,
	        	areaId: areaId,
	        	locationId: locationId,
	        	supplierId: supplierId,
	        	causeId: causeId,
	        	beginDateTime: beginDateTime,
	        	endDateTime: endDateTime,
	        	userId:userId,
	        	deliveryman:deliveryman,
	        	vehicleNo:vehicleNo,
	        	supplierStatus: showForbidden ? supplierStatus : 1,
	    	        	areaStatus: showForbidden ? areaStatus : 1,
	    	        	causeStatus: showForbidden ? causeStatus : 1
	        });
		}
	},
	//查询按钮事件处理
	onSearchOperflow:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportOperflow(button, 1);
	},
	//重置按钮事件
	onClearOperflow:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///重置查询条件
		grid.down('combobox[name=areaNature]').setValue('-1');
		grid.down('combobox[name=areaName]').setValue(-1);
		grid.down('combobox[name=locationNo]').setValue(-1);
		grid.down('combobox[name=supplierName]').setValue('');
		grid.down('combobox[name=operType]').setValue('-1');
		grid.down('combobox[name=demanderName]').setValue('');
		grid.down('combobox[name=remark]').setValue(-1);
		grid.down('textfield[name=goodsCode]').setValue('');
	    grid.down('datefield[name=beginDateTime]').setValue('');
	    grid.down('datefield[name=endDateTime]').setValue('');
		grid.down('combobox[name=userId]').setValue(-1);
		grid.down('textfield[name=deliveryman]').setValue('');
		grid.down('textfield[name=vehicleNo]').setValue('');
		grid.down('checkbox[name=showForbidden]').reset();
	    
		//调用查询按钮事件
		this.onSearchOperflow(button);
	},
	//导出按钮事件
	onExportOperflow:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportOperflow(button, 2);
	}
});