/**
 * 库存信息编辑controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.stock.StockSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'stock.StockSearchView'
	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'stocksearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//库区性质改变事件
	    	'stocksearchview combobox[name=areaNature]': {
	    		change: this.onAreaNatureChange
	    	},
	    	//库区名称改变事件
	    	'stocksearchview combobox[name=areaName]': {
	    		change: this.onAreaNameChange
	    	},
	    	//查询按钮事件
	    	'stocksearchview button[name=btn-search]': {
	    		click: this.onSearchStock
	    	},
	    	//重置按钮事件
	    	'stocksearchview button[name=btn-clear]': {
	    		click: this.onClearStock
	    	},
	    	//导出按钮事件
	    	'stocksearchview button[name=btn-export]': {
	    		click: this.onExportStock
	    	},
	    	//表格事件
	    	'stocksearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(view, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(view, view.functionCodes);
    	
    	//刷新库区名称下拉框数据
    	view.down('combobox[name=areaName]').getStore().reload();
    	//刷新供应商下拉框数据
    	view.down('combobox[name=supplierName]').getStore().reload();
    	//刷新库位下拉框数据
    	view.down('combobox[name=locationNo]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商、库位号、库区名称下拉框数据
		var supplierNameCbx = form.down('combobox[name=supplierName]');
		var locationNoCbx = form.down('combobox[name=locationNo]');
		var areaNameCbx = form.down('combobox[name=areaName]');
		var supplierNameStore = supplierNameCbx.getStore();
		var areaNameStore = areaNameCbx.getStore();
		var locationNoStore = locationNoCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的需方商性质
			//修改供应商store参数
			supplierNameStore.proxy.extraParams = {
				status: 1
			};
			//修改库区名称store参数
			areaNameStore.proxy.extraParams = {
				areaNature: -1,
				status: 1
			};
			//修改库位号store参数
			locationNoStore.proxy.extraParams = {
				areaId: -1,
        	 	areaNature:-1,
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierNameStore.proxy.extraParams = {
				status: -1
			};
			//修改库区名称store参数
			areaNameStore.proxy.extraParams = {
				areaNature: -1,
				status: -1
			};
			//修改库位号store参数
			locationNoStore.proxy.extraParams = {
				areaId: -1,
        	 	areaNature:-1,
				status: -1
			};
		}
		//重加载需方商性质下拉框数据
		supplierNameStore.load();
		areaNameStore.load();
		locationNoStore.load();
		
		//显示禁用项改变时，需方商性质改为全部
		if(showForbidden != null){
			supplierNameCbx.setValue();
			locationNoCbx.setValue(-1);
			areaNameCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchStock(combobox);
	},
	/**
	 * 库区性质改变事件
	 */
	onAreaNatureChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区性质值
		var nature = combobox.getValue();
		
		///1. 根据库区性质重新加载库区下拉框数据
		var areaCbx = form.down('combobox[name=areaName]');
		//将库区性质value值传给库区后台,取得对应的库区名称
		var areaStore = areaCbx.getStore();
		//修改库区store参数
		areaStore.proxy.extraParams = {
			areaNature: nature,
			status: -1
		};
		//重加载库区下拉框数据
		areaStore.load();
		
		///1. 根据库区性质重新加载库位号下拉框数据
		var locationNoCbx = form.down('combobox[name=locationNo]');
		var locationStore = locationNoCbx.getStore();
		//修改库位号store参数
		locationStore.proxy.extraParams = {
			areaId: -1,
			areaNature: nature,
		 	status : -1
		};
		//重加载库位号下拉框数据
		locationStore.load();
		
		//库区性质改变时，库区名称改为全部，库位号改为全部
		if(nature != null){
			areaCbx.setValue(-1);
			locationNoCbx.setValue(-1);
		}
	},
	//库区名称改变事件
	onAreaNameChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var areaId = combobox.getValue();
		var locationNoCbx = form.down('combobox[name=locationNo]');
		//当库区名称改变时，库位号为全部
		if(areaId != null){
			locationNoCbx.setValue(-1);
		}
		
		//取得库区性质值
		var areaNature = form.down('combobox[name=areaNature]').getValue();
		var locationStore = locationNoCbx.getStore();
		//修改库位号store参数
		locationStore.proxy.extraParams = {
			areaId: areaId,
			areaNature: areaNature,
		 	status : -1
		};
		//重加载库位号下拉框数据
		locationStore.load();
	},
	/**
	 * 重置树表格的列
	 * @param totalType 统计方式 0:货物; 1:库位号; 2:供应商
	 * @param tree 树表格控件
	 */
	resetTreeGridColumns: function(totalType, tree) {
		var columns = [
	/*		new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'left'
	      	}),*/
		    {text: '供应商', dataIndex: 'supplierName', width:200, style :"text-align:center",align:'left'},
		    {text: '货物号', dataIndex: 'goodsCode', width:130, style :"text-align:center", align:'left'},
		    {text: '品名', dataIndex: 'goodsName', width:130, style :"text-align:center", align:'left'},
		    {text: '订单号', dataIndex: 'orderNo', width:130, style :"text-align:center", align:'left'},
		    {text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    {text: '数量', dataIndex: 'quantity', width:130, style :"text-align:center", align:'right'},
		    {text: '存放库位', dataIndex: 'locationNo', width:130, style :"text-align:center", align:'left'},
		    {text: '所在库区', dataIndex: 'areaName', width:130, style :"text-align:center", align:'left'},
		    {text: '入库时间', dataIndex: 'instockTime',width:150,style :"text-align:center",align:'left'}
	    ];
		
		switch(parseInt(totalType)) {
		case 0: //货物
			columns.splice(1, 1, {text: '货物号', dataIndex: 'goodsCode', width:130, style :"text-align:center", align:'left', xtype: 'treecolumn'});
			break;
		case 1: //库位号
			columns.splice(6, 1, {text: '存放库位', dataIndex: 'locationNo', width:130, style :"text-align:center", align:'left', xtype: 'treecolumn'});
			break;
		case 2: //供应商
			columns.splice(0, 1, {text: '供应商', dataIndex: 'supplierName', width:200, style :"text-align:center", align:'left', xtype: 'treecolumn'});
			break;
		}
		tree.reconfigure(null, columns); 
	},
	/**
	 * 查询或导出库存信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportStock: function(button, dealType) {
		//取得按钮所在表格
		var tree = button.up('treepanel');

		//取得表单对象
		var form = tree.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		 //取得统计方式
	    var totalType=tree.down('radiogroup[name=totalType]').getValue()["useState"];
	    
	    //取得查询条件
		//货物号
	    var goodsCode=tree.down('textfield[name=goodsCode]').getValue();
		//订单号
	    var orderNo=tree.down('textfield[name=orderNo]').getValue();
	    //取得库位
	    var locationId=tree.down('combobox[name=locationNo]').getValue();
	    //取得库区性质
	    var areaNature=tree.down('combobox[name=areaNature]').getValue();
	    //取得库区名称
	    var areaId=tree.down('combobox[name=areaName]').getValue();
	    //取得供应商
	    var supplierId=tree.down('combobox[name=supplierName]').getValue();
	    //取得显示禁用项
	    var showForbidden=tree.down('checkbox[name=showForbidden]').getValue();
	    //供应商状态
	    var supplierStatus=-1;
	    //库区状态
	    var areaStatus=-1;
	    //库位状态
	    //var locationStatus=-1;
	    
		if(1 == dealType) {//查询
			//重置树表格的列
			this.resetTreeGridColumns(totalType, tree);
			
			tree.down('pagingtoolbar').getStore().proxy.extraParams = {
				goodsCode: goodsCode,
	        	orderNo: orderNo,
	        	locationId: locationId,
	        	areaNature: areaNature,
	        	areaId: areaId,
	        	supplierId: supplierId,
	        	totalType: totalType,
	        	supplierStatus: showForbidden ? supplierStatus : 1,
	        	areaStatus: showForbidden ? areaStatus : 1,
	        	//locationStatus: showForbidden ? locationStatus : 1,
	        	firstLoad: 1
	        };
			
			//分页重新加载store
			tree.down('pagingtoolbar').getStore().loadPage(1);
		} else {//导出
			//导出库存信息
			ACBEE.Ext.Util.submitDummyForm("stock/exportStock.action", {
				goodsCode: goodsCode,
	        	orderNo: orderNo,
	        	locationId: locationId,
	        	areaNature: areaNature,
	        	areaId: areaId,
	        	supplierId: supplierId,
	        	supplierStatus: showForbidden ? supplierStatus : 1,
	        	areaStatus: showForbidden ? areaStatus : 1,
	        	totalType: totalType
	        });
		}
	},
	//查询按钮事件处理
	onSearchStock:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportStock(button, 1);
	},
	//重置按钮事件
	onClearStock:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var tree = button.up('treepanel');
		
		//清空查询条件
		tree.down('textfield[name=goodsCode]').setValue('');
		tree.down('textfield[name=orderNo]').setValue('');
		tree.down('combobox[name=supplierName]').setValue('');
		tree.down('combobox[name=areaNature]').setValue('-1');
		tree.down('combobox[name=areaName]').setValue(-1);
		tree.down('combobox[name=locationNo]').setValue(-1);
		tree.down('radiogroup[name=totalType]').reset();
		tree.down('checkbox[name=showForbidden]').reset();
		//调用查询按钮事件
		this.onSearchStock(button);
	},
	//导出按钮事件
	onExportStock:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportStock(button, 2);
	}
});