/**
 * 分配角色controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-22
 */
Ext.define('WMS.controller.systemservice.AssignRoleCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'systemservice.AssignRoleView',
		'WMS.store.systemservice.userrole.RoleStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//分配角色窗口事件
			'assignroleview': {
				show: this.onShow
			},
			//全选复选框事件
			'assignroleview checkboxfield[name=chkRoleSelectAll]': {
				change: this.onRoleSelectAll
			},
			//保存按钮事件
			'assignroleview  button[name=btn-save]': {
				click: this.onSave
			}
		});
	},
	//分配角色窗口显示事件
	onShow: function(win, eOpts){
		//加载角色
		this.loadRoles(win);
	},
	//全选复选框事件
	onRoleSelectAll: function(chkbox, newValue, oldValue, eOpts) {
		var win = chkbox.up('window');
		var chked = newValue;
		
		//取得角色复选框组
		var roleChkBoxGroup = win.down('checkboxgroup[name=roleGroup]');
		//设置角色复选框组的所有子项的选中状态
		for(var i=0;i<roleChkBoxGroup.items.items.length;i++) {
			roleChkBoxGroup.items.items[i].setValue(chked);
		}
	},
	//加载角色
	loadRoles: function(win) {
		var roleIds = null;
		//根据用户id取得其拥有的角色id数组
		ACBEE.Ext.Util.ajaxRequest('staff/getRoleIdsByUserId.action', {
			userId: win.staffId
		}, function(result, responseText){
			roleIds = result;
		});
		
		//取得角色store
		var roleStore  = Ext.create('WMS.store.systemservice.userrole.RoleStr', {
        	url: 'role/getRoleList.action',
    		params: {
    			status: 1
			}
        });
		
		//取得角色复选框组
		var roleChkBoxGroup = win.down('checkboxgroup[name=roleGroup]');
		//绑定角色store的加载事件
		roleStore.on("load", function(store, records, successful, eOpts){
			//清除原来的角色复选框
			roleChkBoxGroup.removeAll();

			var isChecked = false;
			var index = -1;
			var chkBoxArray = new Array();
			var selectedCount = 0;
			//遍历store，创建角色复选框
			store.each(function(record) {
				isChecked = false;
				if(null != roleIds) {
					//查找当前角色是否存在用户角色列表中
					index = roleIds.indexOf(record.get('roleId'));
					if(-1 != index) {
		        		isChecked = true;
		        		selectedCount++;
		        	}
				}
       	
				chkBoxArray.push({
                	name: 'roleIds', 
                	boxLabel: record.get('roleName'), 
					inputValue: record.get('roleId'),
					checked: isChecked
				});
			});
			//先将复选框添加到数据，再追加到复选框组组件上，是为了提高加载的效率
			roleChkBoxGroup.add(chkBoxArray);
			
			//所有复选框都选中，则设置例行按钮为选中
			if(selectedCount > 0 && selectedCount == store.getCount()) {
				var chkRoleSelectAll = win.down('checkboxfield[name=chkRoleSelectAll]');
				chkRoleSelectAll.setValue(true);
			} 
	    });
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var form = win.down('form');
		
		//提交表单内容到后台
		ACBEE.Ext.Util.submitFormData(form, 'staff/saveUserRoleId.action', {
			userId: win.staffId
		}, "分配角色成功", "分配角色失败！！！", function() {
			win.close();
		});
	}
});