/**
 * 分配用户controller.
 * @author 奚志敏
 * @version 1.0.0, 2015-07-31
 */
Ext.define('WMS.controller.systemservice.AssignUserCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'systemservice.AssignUserView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		
		this.control({
			//分配用户窗口事件
			'assignuserview': {
				show: this.onShow
			},
			//保存按钮事件
			'assignuserview button[name=btn-save]': {
				click: this.onSave
			}
		});
	},
	//分配用户窗口显示事件
	onShow: function(win, eOpts){
		var userIds = null;
		//根据角色id取得其拥有的用户id数组
		ACBEE.Ext.Util.ajaxRequest('role/getUserIdsByRoleId.action', {
			roleId: win.roleId
		}, function(result, responseText){
			userIds = result;
		});
		
		//取得用户列表grid
		var grid = win.down('grid');
		//取得列表grid和store
		var userStore = grid.getStore();
		//获得grid选择模型
		var sm = grid.getSelectionModel();
		
		//绑定用户store的加载事件
		userStore.on("load", function(store, records, successful, eOpts){
			var rs = new Array();
			var index = -1;
			//遍历用户Id store
			store.each(function(record) {
				if(null != userIds) {
					//查找当前用户是否存在用户角色列表中
					index = userIds.indexOf(record.get('staffId'));
					if(-1 != index) {
						rs.push(record);
		        	}
				}
			});
			
			//选中行
			sm.select(rs); 
	    });
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得用户列表grid
		var grid = win.down('grid');
		
		//检测是否选中表格行
		var records = ACBEE.Ext.Util.checkGirdRowSelected(grid, "请至少选择一个用户！");
		if(null == records) {
			return false;
		}
		
		//根据选中的记录取得id数组
		var userIds = ACBEE.Ext.Util.getIdArrayFromRecords(records, 'staffId');
		
		//提交保存角色的用户
		ACBEE.Ext.Util.ajaxSubmitData('role/saveRoleUserId.action', {
			roleId: win.roleId,
			userIds: userIds
		}, "分配用户成功", "分配用户失败！！！", function() {
			win.close();
		});
	}
});