/**
 * 数据库管理controller.
 * @author 楊偉艾
 * @version 1.0.0, 2015-12-08
 */
Ext.define('WMS.controller.systemservice.DatabaseCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'systemservice.DatabaseView'
	],
	requires: [
	   	'WMS.view.systemservice.DatabaseView'
	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//备份按钮事件
	    	'databaseview button[name=btn-backup]': {
	    		click: this.onBackup
	    	},
	    	//还原按钮事件
	    	'databaseview': {
	    		cellclick: this.onGridCellClick
	    	},
	    	//重置按钮事件
	    	'databaseview button[name=btn-clear]': {
	    		click: this.onClear
	    	},
	    	//备份路径事件
	    	'databaseview button[name=btn-serachurl]':{
	    		click: this.onSavePath
	    	},
	    	//查询按钮事件
	    	'databaseview button[name=btn-search]': {
	    		click: this.onSearch
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    },
	//备份按钮事件处理
	onBackup : function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//取得表单对象
		var form = grid.down('form');
		//取得当前登录的操作员Id
		var userId = ACBEE.Ext.Util.loginUserId;
		//取得当前服务器日期
		var curDate = Ext.Date.now().toString();
		//提交表单内容到后台
		ACBEE.Ext.Util.submitFormData(form, 'database/doBackup.action', 
			{ operator: userId
			, backupTime: curDate}, 
			"数据库备份成功", "数据库备份失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
		
		//重新加载store
		store.loadPage(1);
	},
	onGridCellClick : function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
		if(5 == cellIndex) {//操作列
			//检测登录
			if(!ACBEE.Ext.Util.checkSession()) {
				ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
					location.href = "login.html";
				});
				return false;
			}
			var targetName = record.data.targetName;
			var targetPath = record.data.targetPath;
			//提交表单内容到后台
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"正在处理数据，请稍候..."});
			myMask.show();
			ACBEE.Ext.Util.ajaxRequest('database/doRestore.action', {
				dbName: targetName, 
				filePath: targetPath
			}, function(result) {
				myMask.hide();
		    	if(undefined != result && null != result) {
					ACBEE.Ext.Util.showAlertBox("数据库还原成功!", Ext.Msg.INFO, 300);
					hasError = false;
					return true;
				}
				ACBEE.Ext.Util.showAlertBox("数据库还原失败！", Ext.Msg.WARNING, 300);
					hasError = true;
					return false;
			});
		}
	},
	// 查询按钮事件
	onSearch : function(button){
		// 检测会话超时
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		// 取得表格
		var grid = button.up('grid');
		// 设置查询参数
		var form = grid.down('from');
		// 操作员
		var operator = grid.down('textfield[name=userName]').getValue();
		// 文件名称
		var targetName = grid.down('textfield[name=fileName]').getValue();
		// 备份开始时间
		var startBackupTime = "";
		if (grid.down('datetimefield[name=startBackupTime]').getValue() != null){
			startBackupTime = Ext.Date.format(new Date(grid.down('datetimefield[name=startBackupTime]').getValue()),'Y-m-d H:i:s');
		}
		// 备份截止时间
		var endBackupTime = "";
		if (grid.down('datetimefield[name=endBackupTime]').getValue() != null){
			endBackupTime = Ext.Date.format(new Date(grid.down('datetimefield[name=endBackupTime]').getValue()),'Y-m-d H:i:s');
		}
	    grid.getStore().proxy.extraParams = {
			operator: operator,
			targetName: targetName,
			startBackupTime: startBackupTime,
			endBackupTime: endBackupTime
		};
		// 重新加载store
		grid.getStore().loadPage(1);
	},
	//重置按钮事件
	onClear:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///重置查询条件
		grid.down('textfield[name=userName]').setValue('');
		grid.down('textfield[name=fileName]').setValue('');
		/*
		 * bug:726 杨志文 对备份时间做了重置
		 */
		grid.down('datefield[name=startBackupTime]').setValue('');
		grid.down('datefield[name=endBackupTime]').setValue('');
		//调用查询按钮事件
		this.onSearch(button);
	},
	//选择备份目录事件
	onSavePath:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//alert(0);
		/*//取得按钮所在表格
		var grid = button.up('grid');
		//取得表单对象
		var form = grid.down('form');
		ACBEE.Ext.Util.fileSerach();*/
		//console.log(ACBEE.Ext.FileBrowserWindow);
		//var code = Ext.hoo.component.getPath();
		
	}
});