/**
 * 数据字典编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.controller.systemservice.DictEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'systemservice.DictEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'dicteditview  button[name=btn-save]': {
				click: this.onSave
			}
		});
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！", null, 300);
			return false;
		}
		
		//取得原Id
		var oldDictId = win.oldDictId;
		//取得类型和名称
		var dictType = win.dictType;
		var dictTypeName = win.dictTypeName;
		
		//提交表单内容到后台
		ACBEE.Ext.Util.submitFormData(form, 'dict/saveDict.action', {
			dictId: oldDictId, 
			dictType: dictType
		}, dictTypeName + "信息保存成功", dictTypeName + "信息保存失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});