/**
 * 数据字典查询controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.controller.systemservice.DictSearchCtl', {
	extend: 'Ext.app.Controller', 
    views: [
    	'systemservice.DictSearchView'
	],
    init: function () {
    	this.control({
	    	//添加按钮事件
	    	'dictsearchview button[name=btn-add]': {
	    		click: this.onAddDict
	    	},
	    	//查询按钮事件
	    	'dictsearchview button[name=btn-search]': {
	    		click: this.onSearchDict
	    	},
	    	//删除按钮事件
	    	'dictsearchview button[name=btn-delete]': {
	    		click: this.onDeleteDict
	    	},
	    	//清空按钮事件
	    	'dictsearchview button[name=btn-clear]': {
	    		click: this.onClearDict
	    	},
	    	//启用按钮事件
	    	'dictsearchview button[name=btn-openStatus]': {
	    		click: this.onOpenStatus
	    	},
	    	//禁用按钮事件
	    	'dictsearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseStatus
	    	},
	    	//表格事件
	    	'dictsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
		});
    },
    /**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    },
	//查询按钮事件处理
	onSearchDict: function(button){
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//取得查询条件
		//取得所属库区性质
		var dictName = grid.down('textfield[name=dictName]').getValue();
		//取得性质名称
	    var dictType = grid.dictType;
	    //取得状态
	    var status = grid.down('combobox[name=status]').getValue();
	    
	    grid.getStore().proxy.extraParams = {
	    	dictName: dictName,
	    	dictType: dictType,
			status: status
		};
		//重新加载store
		grid.getStore().loadPage(1);
	},
	//清空按钮事件
	onClearDict:function(button){
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///清空查询条件
		grid.down('textfield[name=dictName]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		
		//调用查询按钮事件
		this.onSearchDict(button);
	},
	//添加按钮事件处理
	onAddDict:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var grid = button.up('grid');
		//加载库区编辑控制器
	    ACBEE.Ext.Util.loadController(this.application, "systemservice.DictEditCtl");
	    //显示库区window
		var win = ACBEE.Ext.Util.getWin('dicteditview');
		//清除表单内容
		win.down('form').getForm().reset();
		//保存类型
		win.dictType = grid.dictType;
		//保存类型名称
		win.dictTypeName = grid.title;
		//设置数据字典Id为空
		win.oldDictId = 0;
		//保存当前表格的store
		win.parentStore = grid.getStore();
		win.setTitle('添加' + grid.title);
		
		var dictTypeLabel = win.down('label[name=dictTypeLabel]');
		dictTypeLabel.setText(grid.title + ':');
		var dtWidth = grid.title.length * 15;
		dictTypeLabel.setWidth(dtWidth);
		win.down('label[name=dictTypeLabelFlag]').setWidth(80 - dtWidth);
		
		win.show();
	},
	//显示编辑页面
	onModifyDict: function(grid, record){
		//加载数据字典编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.DictEditCtl");
		//取得数据字典window
		var win = ACBEE.Ext.Util.getWin('dicteditview');
		
		//保存类型
		win.dictType = grid.panel.dictType;
		//保存类型名称
		win.dictTypeName = grid.panel.title;
		//保存原数据字典Id
		win.oldDictId = record.data.dictId;
		//保存父窗体表格store
		win.parentStore = grid.getStore();
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改' + grid.panel.title + '[' + record.get('dictName') + ']');
		var dictTypeLabel = win.down('label[name=dictTypeLabel]');
		dictTypeLabel.setText(grid.panel.title + ':');
		
		var dtWidth = grid.panel.title.length * 15;
		dictTypeLabel.setWidth(dtWidth);
		win.down('label[name=dictTypeLabelFlag]').setWidth(80 - dtWidth);
		
		win.show();
	},
	//删除按钮事件处理
	onDeleteDict:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'dictId', 'dict/delDict.action', grid.title, {dictType: grid.dictType});
	},
	//添加启用按钮事件
	onOpenStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'dictId', 'dict/updateStatus.action', grid.title, 1, 'status', {dictType: grid.dictType});
	},
	//添加禁用按钮事件
	onCloseStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'dictId', 'dict/updateStatus.action', grid.title, 0, 'status', {dictType: grid.dictType});
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(5 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onModifyDict(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = grid.panel.title + '[' + record.get('dictName') + ']';
				var id = record.get('dictId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'dict/delDict.action', {dictType: grid.panel.dictType});
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onModifyDict(grid, record);
		}
	}
});