/**
 * 数据字典维护导航菜单controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.controller.systemservice.DictionaryMaintainCtl', {
	extend: 'Ext.app.Controller', 
    views: [
    	'systemservice.DictionaryMaintainView',
    	'systemservice.DictSearchView',
    	'systemservice.LocationNatureSearchView',
    	'systemservice.GoodCategoryMaintainView'
	],
    init: function () {
    	this.control({
	    	//菜单视图
	    	'dictionarymenuview': {
	    		//树结点单击事件
	    		itemclick: this.onTreeItemClick,
	    		//视图渲染后事件
				afterrender: this.onAfterRender
			}
		});
    },
    /**
     * 数据字典导航树视图渲染后事件
     */
    onAfterRender: function(tree, eOpts) {
    	var dictMenuStore = tree.getStore();
    	var me = this;
    	
    	//绑定树store的加载事件
    	dictMenuStore.on("load", function(store, node, records, successful, eOpts ){
    		if(null != records && records.length > 0) {
    			var children = records[0].data.children;
    			if(null != children && children.length > 0) {
    				var r = children[0];
    				var params = r.params;
    				params = ('' == params ? '' : eval('(' + params + ')'));
    				var dictType = ('' == params ? 0 : params.dictType);
    				//取得第一个根的第一个节点
    				var firstNode = node.getChildAt(0);
    				if(null != firstNode && undefined != firstNode) {
    					firstNode = firstNode.firstChild;
    					if(null != firstNode && undefined != firstNode) {
    						//选中树结点
    	    				tree.getSelectionModel().select(firstNode);
    					}
    				}
    					
    				//打开数据字典操作界面
    				me.openDictPanel(r.ctlName, r.viewAlias, r.text, dictType, r.functionCodes);
    			}
    		}
	    });
    },
    /**
     * 树结点单击事件
     */
    onTreeItemClick : function(view, record, item, index, e, eOpts){
    	if(!record.get('leaf')) {
    		return;
    	}
    	
    	//取得参数
	    var viewAlias = record.get('menuNo');
	    var ctlName = record.get('ctlName');
		var fieldText = record.get('text');
		var params = record.get('params');
		params = ('' == params ? '' : eval('(' + params + ')'));
		var dictType = ('' == params ? 0 : params.dictType);
		var functionCodes = record.get('functionCodes');
		
		//打开数据字典操作界面
		this.openDictPanel(ctlName, viewAlias, fieldText, dictType, functionCodes);
    },
    /**
     * 打开数据字典操作界面
     * @param ctlName	控制器名称，null时表示为默认数据字典
     * @param viewAlias 视图别名，null时表示为默认数据字典视图
     * @param fieldText	名称
     * @param dictType	字典类型，为空时，根据ctlName, viewAlias去加载模块，否则按默认数据字典处理
     * @param functionCodes 功能代码数组
     */
    openDictPanel: function(ctlName, viewAlias, fieldText, dictType, functionCodes) {
    	if(undefined == viewAlias || null == viewAlias) {
	    	viewAlias = 'dictsearchview';
	    	ctlName = 'WMS.controller.systemservice.DictSearchCtl';
	    }
    	
    	//加载控制器
    	this.application.getController(ctlName);
    	//取得panel
    	var panel = Ext.getCmp(viewAlias);
    	if(!panel){  //panel不存在，则创建
            panel = {
                xtype: viewAlias,
                dictType: dictType,
                title: fieldText,
                functionCodes: functionCodes
            };
		}
    	//取得右侧区域panel
    	var rightPanel = Ext.getCmp('rightPanel');
    	
    	var oldPanel = rightPanel.down('panel');
    	//panel不存在，则删除当前取得的panel
    	if(null != oldPanel) {
    		rightPanel.remove(0, false); 
    		rightPanel.doLayout();
    	}
		rightPanel.add(panel);
		rightPanel.doLayout();
    	
    	if('dictsearchview' == panel.xtype) {
    		var grid = rightPanel.down('grid');
    		grid.setTitle(fieldText);
    		grid.dictType = dictType;
    		grid.functionCodes = functionCodes;
    		
    		//修改查询条件lable名称
    		grid.down('label[name=dictTypeLabel]').setText(fieldText + ':');
    		var columns=grid.columns; 
    		//修改表格列名称
    		columns[1].setText(fieldText + '名称');
    		
    		//清空查询条件
    		grid.down('textfield[name=dictName]').setValue('');
    		grid.down('combobox[name=status]').setValue('-1');
    		
    		//取得查询按钮
    		var btnSearch = grid.down('button[name=btn-search]');
    		//触发查询按钮单击事件
    		btnSearch.fireEvent('click', btnSearch);
    	}
    }
});