/**
 * 货物类别维护导航菜单controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.controller.systemservice.GoodCategoryMaintainCtl', {
	extend: 'Ext.app.Controller', 
	views : [
		'WMS.view.systemservice.GoodCategoryMaintainView'
	],
	requires:[
	     'WMS.view.systemservice.GoodsCategoryAddEditView',
		 'WMS.controller.systemservice.GoodsCategoryAddEditCtl'
	],
    init: function () {
    	this.control({
        	//添加按钮事件
	    	'goodcategorysearchview button[name=btn-add]': {
	    		click: this.onAddGoodsCategory
	    	},
	    	//查询按钮事件
	    	'goodcategorysearchview button[name=btn-search]': {
	    		click: this.onSearchBtn
	    	},
	    	//删除按钮事件
	    	'goodcategorysearchview button[name=btn-delete]': {
	    		click: this.onDeleteCategory
	    	},
	    	//清空按钮事件
	    	'goodcategorysearchview button[name=btn-clear]': {
	    		click: this.onClearBtn
	    	},
	    	//启用按钮事件
	    	'goodcategorysearchview button[name=btn-openStatus]': {
	    		click: this.onOpenStatus
	    	},
	    	//禁用按钮事件
	    	'goodcategorysearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseStatus
	    	},
	    	//导入按钮事件
	    	'goodcategorysearchview button[name=btn-import]': {
	    		click: this.onImportCategory
	    	},
	    	//导出按钮事件
	    	'goodcategorysearchview button[name=btn-export]': {
	    		click: this.onExportCategory
	    	},
	    	//表格事件
	    	'goodcategorysearchview' : {
	    		cellclick: this.onGridCellClick,
	    		//视图渲染后事件
				afterrender: this.onGridAfterRender,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	},
	    	'goodcategorytreeview' : {
	    		itemclick: this.onTreeItemClick,
	    		//视图渲染后事件
				afterrender: this.onTreeAfterRender
	    	}
		});
    },
    /**
     * 货物类别树渲染后事件
     */
    onTreeAfterRender: function(tree, eOpts) {
		var grid = Ext.getCmp('goodcategorysearchview');
    	grid.parentId = 0;
    	grid.node = tree.getRootNode();
    },
    /**
     * 表格渲染后事件
     */
    onGridAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.ownerCt.functionCodes);
    },
	//添加按钮事件处理
    onAddGoodsCategory:function(button){
    	//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
    	var grid = button.up('grid');
	    	if(grid.parentId!=0 && grid.node.parentNode.parentNode != null ){
	    		ACBEE.Ext.Util.showAlertBox("货物类别仅限于添加二级类别！", null, 300);
	    	} else {
	    		//加载货物类别编辑控制器
		        ACBEE.Ext.Util.loadController(this.application, "systemservice.GoodsCategoryAddEditCtl");
				//取得货物类别window
				var win = ACBEE.Ext.Util.getWin('goodsCategoryAddEditView');
				//清除表单内容
				win.down('form').getForm().reset();
				win.oldGcId = 0;
				win.treeNode = grid.node;
				win.parentId = grid.parentId;
				if(null != win.parentId){
					//保存当前表格的store
					win.parentStore = button.up('grid').getStore();
					win.show();
				}
	    	}
	},
	/**
	 * 查询或导出员货物类别信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportGoodsCategory: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');
		//取得表单对象
		var form = grid.down('form');
		
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		//取得查询条件
		//取得货物类别名称
		var name = grid.down('textfield[name=name]').getValue();
		//取得货物Id
		gcId=grid.parentId;
		//取得状态
		var status = grid.down('textfield[name=status]').getValue();
		//取得左侧树中选中的类别
		var gcId = grid.parentId;
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				name: name,
				gcId: gcId,
				status: status
			};
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出货物类别信息
			ACBEE.Ext.Util.submitDummyForm("goodsCategory/exportGoodsCategory.action", {
				gcId: gcId,
				name: name,
				status: status
	        });
		}
	},
    //查询按钮事件处理
	onSearchBtn:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportGoodsCategory(button, 1);
	},
	//删除按钮事件处理
	onDeleteCategory:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在的表格
		var grid = button.up('grid');
		/**
		 * 李树雪2015.12.29
		 * bug750
		 * code:178-210
		 */
		/*if(grid.node.parentNode != null){
    		ACBEE.Ext.Util.showAlertBox("货物类别仅限于二级,您所选择的货物类别属于二级,因此没有货物类别来删除！", null, 300);
    	} else {
			//提交删除表格的多条数据
			ACBEE.Ext.Util.ajaxDelGridData(grid, 'gcId', 'goodsCategory/delGoodsCategoryMaintain.action','货物类别',null,function(){
				//取得删除的多条数据index
				var records=grid.getSelectionModel().getSelection();
				var gridpanel = Ext.getCmp('goodcategorysearchview');
				var treeNode=gridpanel.node;
				for(var i=0;i<records.length;i++){
					for(var j=0;j<treeNode.childNodes.length;j++){
						var nodeName=treeNode.childNodes[j].data.text.replace( /^\s+|\s+$/g, "" );
						if(records[i].data.name.replace( /^\s+|\s+$/g, "" )==nodeName){
							treeNode.childNodes[j].remove();
						}
					}
				}
			},null);
    	}*/
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'gcId', 'goodsCategory/delGoodsCategoryMaintain.action','货物类别',null,function(){
			//取得删除的多条数据index
			var records=grid.getSelectionModel().getSelection();
			var gridpanel = Ext.getCmp('goodcategorysearchview');
			var treeNode=gridpanel.node;
			for(var i=0;i<records.length;i++){
				for(var j=0;j<treeNode.childNodes.length;j++){
					var nodeName=treeNode.childNodes[j].data.text.replace( /^\s+|\s+$/g, "" );
					if(records[i].data.name.replace( /^\s+|\s+$/g, "" )==nodeName){
						treeNode.childNodes[j].remove();
					}
				}
			}
		},null);
	},
	//清空按钮事件
	onClearBtn:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在的表格
		var grid=button.up('grid');
		
		//查询条件
		grid.down('textfield[name=name]').setValue('');
		grid.down('textfield[name=status]').setValue('-1');
	  	
	  	//调用查询按钮事件
	  	this.onSearchBtn(button);
	},
	//启用按钮事件
	onOpenStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		/**
		 * 李树雪2015.12.29
		 * bug755
		 * code:247-252
		 */
		/*if(grid.node.parentNode != null){
    		ACBEE.Ext.Util.showAlertBox("货物类别仅限于二级,您所选择的货物类别属于二级,因此没有货物类别用来被启用！", null, 300);
    	} else {
    		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'gcId', 'goodsCategory/updateGoodsCategoryStatus.action', '货物类别名称', 1, 'status');
    	}*/
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'gcId', 'goodsCategory/updateGoodsCategoryStatus.action', '货物类别名称', 1, 'status');
	},
	//禁用按钮事件
	onCloseStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		/**
		 * 李树雪2015.12.29
		 * bug750
		 * code:270-275
		 */
		/*if(grid.node.parentNode != null){
    		ACBEE.Ext.Util.showAlertBox("货物类别仅限于二级,您所选择的货物类别属于二级,因此没有货物类别用来被禁用！", null, 300);
    	} else {
			ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'gcId', 'goodsCategory/updateGoodsCategoryStatus.action', '货物类别名称', 0, 'status');
    	}*/
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'gcId', 'goodsCategory/updateGoodsCategoryStatus.action', '货物类别名称', 0, 'status');
	},
	//导入按钮事件
	onImportCategory:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		if(grid.parentId!=0 && grid.node.parentNode.parentNode != null){
    		ACBEE.Ext.Util.showAlertBox("货物类别仅限于二级！", null, 300);
    	} else {
    		//取得类别树
			var treepanel = Ext.getCmp('goodcategorytreeview');
			//导入类别
			ACBEE.Ext.Util.importExcelFile(this.application, "goodsCategory/importGoodsCategory.action", 
				"货物类别信息",  button.up('grid').getStore(), function(store, successList, params) {
				//重新加载类别树
				params.tree.getStore().reload();
				///由于重新加载后结点会出问题
				///采用先关闭全部结点，再打开全部结点的方式刷新树
				params.tree.collapseAll(function (optional) {
					params.tree.expandAll();
				});
			}, {
				tree: treepanel
			});
    	}
	},
	//导出按钮事件
	onExportCategory:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		if(grid.parentId!=0 && grid.node.parentNode.parentNode != null){
    		ACBEE.Ext.Util.showAlertBox("货物类别仅限于二级,您所选择的货物类别属于二级,因此没有货物类别被导出！", null, 300);
    	} else {
			this.onSearchOrExportGoodsCategory(button, 2);
    	}
	},
	//添加修改按钮事件
	onUpdateGoodsCategory:function (grid,record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载货物类别编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.GoodsCategoryAddEditCtl");
		//取得货物类别window
		var win = ACBEE.Ext.Util.getWin('goodsCategoryAddEditView');
		//保存原货物类别Id
	  	win.oldGcId=record.data.gcId;
	  	//表格获取Index:从0开始
	  	win.index=record.index;
	  	//树:从0开始
	  	var grid = Ext.getCmp('goodcategorysearchview');
  		win.treeNode = grid.node;
	    win.parentId=grid.parentId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	win.down('button[name=btn-save]').show();
	  	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
	  	win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(4 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateGoodsCategory(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '货物类别 [' + record.get('name') + ']';
				var id = record.get('gcId');
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'goodsCategory/delGoodsCategoryMaintain.action',null,function(){
					//获取表格中的index，通过index找到此货物类别在树中的位置
					var selectIndex=record.index;
					//获取点击的树的节点
					var gridpanel = Ext.getCmp('goodcategorysearchview');
					var treeNode=gridpanel.node;
					//获取到具体的节点
					var delNode=treeNode.childNodes[selectIndex];
					delNode.remove();
				});
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.ownerCt.functionCodes.indexOf('edit')) {
			this.onUpdateGoodsCategory(grid, record);
		}
	},
	/**
	 * 类别树点击事件
	 */
	onTreeItemClick : function(tree, record, item, index, e, eOpts){
		var treepanel = tree.up('treepanel');
		var panel = treepanel.up('panel');
		var grid = panel.down('grid');
		
		//将查询条件的名称置为空
    	grid.down('textfield[name=name]').setValue('');
    	
    	//取得树中类别id
    	var gcId = record.data.id;
    	//取得当前选中的节点
    	var node = treepanel.getSelectionModel().getLastSelected();
    	//取得右侧表格的store
    	var store = grid.getStore();
	   
    	//叶子结点，则清空数据
    	if(node.leaf) {
        	store.removeAll();
			grid.parentId = null;
        	return;
        } 
		grid.node = node;
		grid.parentId = gcId;

		var button = grid.down('button[name=btn-search]');
		//查询出选中节点下的所有子类别
		this.onSearchOrExportGoodsCategory(button, 1);
	}
});