/**
 * 货物类别view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-08-06
 */
Ext.define('WMS.controller.systemservice.GoodsCategoryAddEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'systemservice.GoodsCategoryAddEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'goodsCategoryAddEditView  button[name=btn-save]': {
				click: this.onSave
			}
		});
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		//取得原货物类别Id
		var oldGcId = win.oldGcId;
		//取得一级类别
		var parentId=win.parentId;
		//提交表单内容到后台
		ACBEE.Ext.Util.submitFormData(form, 'goodsCategory/saveGoodsCategory.action', {oldGcId: oldGcId,parentId:parentId}, 
			"货物类别信息保存成功", "货物类别信息保存失败！！！", function(result) {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
				var treeNode=win.treeNode;
				if(oldGcId==0){
					treeNode.data.leaf = false;
					var gcName = form.down('textfield[name=name]').getValue();
					var newNode = Ext.create('Ext.data.NodeInterface');  
					newNode = treeNode.createNode(newNode);
		            newNode.set('text', gcName);
		            newNode.set('id', result.map.gcId);
		            newNode.set('iconCls', 'no-icon');
		            newNode.set('leaf', true);
					treeNode.appendChild(newNode);
				}
				else{
					//通过win.index来获取表格数据在树中的位置：表格和树的数据排序要一致
				//	var selectNode=treeNode.childNodes[win.index];
				  //  selectNode.set("text",form.down('textfield[name=name]').getValue());
				}
			}
			win.close();
		});
	}
});