/**
 * 授权管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-22
 */
Ext.define('WMS.controller.systemservice.GrantAuthorCtl', {
	extend: 'Ext.app.Controller', 
    views: [
    	'systemservice.GrantAuthorView'
	],
    init: function () {
    	//调用父类方法
    	this.control({
    		//窗体事件
	    	'grantauthorview': {
	    		show: this.onShow
	    	},
	    	//保存事件
	    	'grantauthorview button[name=btn-save]': {
	    		click: this.onGrantAuthor
	    	},
	    	//添加树事件
	    	'grantauthorview treepanel[name=tree]':{
	    		//树复选框选中改变事件
	    		checkchange: this.onCheckChange
	    	}
		});
    },
    /**
     * 窗体显示事件处理方法
     */
    onShow: function(win, eOpts) {
    	//创建模块树store
    	var store = Ext.create('WMS.store.menufunction.MenuStr', {
    		url: 'role/getModuleTree.action',
    		params: {
            	roleId: win.roleId
            }
    	});
		store.load();
		
		var tree = win.down('treepanel');
		//绑定树的store
		tree.bindStore(store);
		
		//监听store的加载事件
		store.on("load", function(store, records, successful, eOpts){
			//取得根结点
			var rootNode = tree.getRootNode();
			if(rootNode.hasChildNodes()) {
				//展开根结点
				rootNode.expand();
				
				//遍历，展开二级节点
				rootNode.eachChild(function(child){  
					child.expand();
        		});
			}
		});
    },
    //保存事件
    onGrantAuthor: function(button){
    	//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
    	var win = button.up('window');
    	var tree = win.down('treepanel');
    	
    	var nodes = tree.getChecked();
    	if(null == nodes || nodes.length <= 0) {
    		ACBEE.Ext.Util.showAlertBox('请至少选择一个权限！');
    		return false;
    	}
    	
    	var mfIds = new Array();
    	for(var i = 0; i < nodes.length; i++) {
    		//有子节点，则跳过
    		if(!nodes[i].hasChildNodes()) {
    			mfIds.push(nodes[i].data.menuNo);
    		}
    	}
    	if(null == mfIds || mfIds.length <= 0) {
    		ACBEE.Ext.Util.showAlertBox('请至少选择一个权限！');
    		return false;
    	}
    	
		//提交保存角色的用户
		ACBEE.Ext.Util.ajaxSubmitData('role/saveRoleFunctionId.action', {
			roleId: win.roleId,
			mfIds: mfIds
		}, "赋权成功", "赋权失败！！！", function() {
			win.close();
		});
    },
    /**
     * 设置当前结点的祖先结点选中状态
     * @param node: 当前结点
     * @param checked: 选中状态
     */
    setAncestorsNodeCheckStatus: function(node, checked) {
    	var tmpNode = node;
    	var childrenCheckedCount = 0;
    	//遍历当前结点的祖先结点，设置为不选中
    	while(true) {
    		tmpNode = tmpNode.parentNode;
    		if(null == tmpNode || undefined == tmpNode) {
    			return;
    		}
    	
    		if(!checked) {
    			tmpNode.set('checked', false);
    		} else {
    			//有子结点，则要判断是否所有子结点选中，如都选中，则将本身选中
        		if(tmpNode.hasChildNodes()) {
        			childrenCheckedCount = 0;
        			//遍历子结点，取得选中个数
            		tmpNode.eachChild(function(child){  
            			if(child.get('checked')){
            				childrenCheckedCount++;
            	   		}
            		});
            		
            		//如子结点都选中，则将本身设为选中
            	    if(childrenCheckedCount == tmpNode.childNodes.length){
            	    	tmpNode.set('checked', true);
        		    }
        		}
    		}
    	}
    },
    /**
     * 设置当前结点的子结点选中状态
     * @param node: 当前结点
     * @param checked: 选中状态
     */
    setChildrenNodeCheckStatus: function(node, checked) {
    	var me = this;
    	node.eachChild(function (child){  
			child.set('checked', checked);
			
			//遍历结点的子结点，设置选中状态
	        me.setChildrenNodeCheckStatus(child, checked);
	    }); 
    },
    /**
     * 树复选框选中改变事件
     * 子节点全选中时，将父节点也选中
     */
    onCheckChange:function(node, checked){
    	//设置当前结点选中状态
    	node.checked = checked;
    	
    	//设置子结点选中状态
        this.setChildrenNodeCheckStatus(node, checked);
    	
    	//设置祖先结点选中状态
    	this.setAncestorsNodeCheckStatus(node, checked);
    }
});