/**
 * 库位性质管理controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.controller.systemservice.LocationNatureSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'systemservice.LocationNatureSearchView'
	],
	requires: [
	    'WMS.view.systemservice.LocationNatureEditView',
	    'WMS.controller.systemservice.LocationNatureEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
        	//添加按钮事件
	    	'locationnaturesearchview button[name=btn-add]': {
	    		click: this.onAddLocationNature
	    	},
	    	//删除按钮事件
	    	'locationnaturesearchview button[name=btn-delete]': {
	    		click: this.onDeleteLocationNature
	    	},
	    	//查询按钮事件
	    	'locationnaturesearchview button[name=btn-search]': {
	    		click: this.onSearchLocationNature
	    	},
	    	//清空按钮事件
	    	'locationnaturesearchview button[name=btn-clear]': {
	    		click: this.onClearLocationNature
	    	},
	    	//启用按钮事件
	    	'locationnaturesearchview button[name=btn-openStatus]': {
	    		click: this.onOpenStatus
	    	},
	    	//禁用按钮事件
	    	'locationnaturesearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseStatus
	    	},
	    	//表格事件
	    	'locationnaturesearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    },
	//修改按钮事件处理方法
	onModify:function(grid, record){
		//加载库位性质编辑控制器
       ACBEE.Ext.Util.loadController(this.application, "systemservice.LocationNatureEditCtl");
		//显示库位性质window
		var win = ACBEE.Ext.Util.getWin('locationnatureeditview');

		//保存原库位性质Id
		win.oldNatureId = record.data.natureId;
		//保存父窗体表格store
		win.parentStore = grid.getStore();
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改库位性质 [' + record.get('natureName') + ']');
		win.show();
	},
	//添加按钮事件处理
	onAddLocationNature:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载库位性质编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.LocationNatureEditCtl");
		//取得库位性质window
		var win = ACBEE.Ext.Util.getWin('locationnatureeditview');
		//清除表单内容
		win.down('form').getForm().reset();
		//设置库位性质Id为空
		win.oldNatureId = 0;
		//保存当前表格的store
		win.parentStore = button.up('grid').getStore();
		win.setTitle('添加库位性质信息');
		win.show();
	},
	//删除按钮事件处理
	onDeleteLocationNature:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'natureId', 'locationNature/delLocationNature.action', '库位性质');
	},
	//查询按钮事件处理
	onSearchLocationNature:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//取得查询条件
		//取得所属库区性质
		var areaNature = grid.down('textfield[name=areaNature]').getValue();
		//取得性质名称
	    var natureName = grid.down('textfield[name=natureName]').getValue();
	    //取得状态
	    var status = grid.down('combobox[name=status]').getValue();
	    
	    grid.getStore().proxy.extraParams = {
	    	areaNature: areaNature,
	    	natureName: natureName,
			status: status
		};
		//重新加载store
		grid.getStore().loadPage(1);
	},
	//清空按钮事件处理
	onClearLocationNature:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///清空查询条件
		grid.down('combobox[name=areaNature]').setValue('-1');
		grid.down('textfield[name=natureName]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		
		//调用查询按钮事件
		this.onSearchLocationNature(button);
	},
	//启用按钮事件处理
	onOpenStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'natureId', 'locationNature/updateStatus.action', '库位性质', 1, 'status');
	},
	//禁用按钮事件处理
	onCloseStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'natureId', 'locationNature/updateStatus.action', '库位性质', 0, 'status');
	},	
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(5 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onModify(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '库位性质名称[' + record.get('natureName') + ']';
				var id = record.get('natureId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'locationNature/delLocationNature.action');
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onModify(grid, record);
		}
	}
});