/**
 * 日志信息编辑controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-09-15
 */
Ext.define('WMS.controller.systemservice.LogSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'systemservice.LogSearchView'
	],
	requires: [
	   	    'WMS.view.systemservice.LogDetailView'
	      	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//查询按钮事件
	    	'logsearchview button[name=btn-search]': {
	    		click: this.onSearchLog
	    	},
	    	//重置按钮事件
	    	'logsearchview button[name=btn-clear]': {
	    		click: this.onClearLog
	    	},
	    	//表格事件
	    	'logsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    },
	//查询按钮事件处理
	onSearchLog:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//获得查询条件
		//取得操作员
		var userName = grid.down('textfield[name=userName]').getValue();
		//取得操作开始时间
		if(grid.down('datetimefield[name=beginDateTime]').getValue()==null)
	    	var beginDateTime="";
	    else
	    	beginDateTime = Ext.Date.format(new Date(grid.down('datetimefield[name=beginDateTime]').getValue()),'Y-m-d H:i:s');
		//取得操作结束时间
	    if(grid.down('datetimefield[name=endDateTime]').getValue()==null)
    		var endDateTime="";
    	else
    		endDateTime = Ext.Date.format(new Date(grid.down('datetimefield[name=endDateTime]').getValue()),'Y-m-d H:i:s');
		//取得模块
		var moduleId = grid.down('textfield[name=moduleName]').getValue();
		//取得日志内容
		var logContent = grid.down('textfield[name=logContent]').getValue();
		//取得IP地址
		var IP = grid.down('textfield[name=IP]').getValue();
		
		//取得入库需求单的store
		var store = grid.getStore();
		store.proxy.extraParams = {
			userName : userName,
			beginDateTime : beginDateTime,
			endDateTime : endDateTime,
			moduleId : moduleId,
			logContent : logContent,
			IP : IP
		};
		//重新加载store
		store.loadPage(1);
	},
	//重置按钮事件
	onClearLog:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///重置查询条件
		grid.down('textfield[name=userName]').setValue('');
		grid.down('datetimefield[name=beginDateTime]').setValue('');
		grid.down('datetimefield[name=endDateTime]').setValue('');
		grid.down('textfield[name=moduleName]').setValue('');
		grid.down('textfield[name=logContent]').setValue('');
		grid.down('textfield[name=IP]').setValue('');
		
		//调用查询按钮事件
		this.onSearchLog(button);
	},
	//删除按钮事件处理
	onDeleteLog:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在的表格
		var grid = button.up('grid');
		//提交删除表格的多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'logId', 'log/delLog.action', '日志');
	},
	//显示详情事件
	onShowInfo : function(grid, record){
		//取得日志window
		var win = ACBEE.Ext.Util.getWin('logdetailview');
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(6 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('detail')) {
			this.onShowInfo(grid, record);
		}
	}
});