/**
 * 角色信息管理controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.controller.systemservice.RoleSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'systemservice.RoleSearchView'
	],
	requires: [
	    'WMS.view.systemservice.RoleEditView',
	    'WMS.controller.systemservice.RoleEditCtl',
	    'WMS.view.systemservice.GrantAuthorView',
	    'WMS.controller.systemservice.GrantAuthorCtl',
	    'WMS.controller.systemservice.AssignUserCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//查询按钮事件
	    	'rolesearchview button[name=btn-search]': {
	    		click: this.onSearchRole
	    	},
	    	//清空按钮事件
	    	'rolesearchview button[name=btn-clear]': {
	    		click: this.onClearRole
	    	},
        	//添加按钮事件
	    	'rolesearchview button[name=btn-add]': {
	    		click: this.onAddRole
	    	},
	    	//删除按钮事件
	    	'rolesearchview button[name=btn-delete]': {
	    		click: this.onDeleteRole
	    	},
	    	//启用按钮事件
	    	'rolesearchview button[name=btn-openStatus]': {
	    		click: this.onOpenStatus
	    	},
	    	//禁用按钮事件
	    	'rolesearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseStatus
	    	},
	    	//表格事件
	    	'rolesearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    },
    //查询按钮事件处理
	onSearchRole:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//获得查询条件
		//取得角色名称
		var roleName = grid.down('textfield[name=roleName]').getValue();
		//取得状态
	    var status=grid.down('combobox[name=status]').getValue();
	    grid.getStore().proxy.extraParams = {
	    	roleName: roleName,
			status: status
		};
		//重新加载store
		grid.getStore().loadPage(1);
	},
	//清空按钮事件处理方法
	onClearRole:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///清空查询条件
		grid.down('textfield[name=roleName]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		
		//调用查询按钮事件
		this.onSearchRole(button);
	},
	//添加按钮事件处理方法
	onAddRole:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载角色编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.RoleEditCtl");
		//取得角色window
		var win = ACBEE.Ext.Util.getWin('roleeditview');
		//清除表单内容
		win.down('form').getForm().reset();
		//设置角色Id为空
		win.roleId = 0;
		//保存当前表格的store
		win.parentStore = button.up('grid').getStore();
		win.setTitle('添加角色');
		win.show();
	},
	//修改按钮事件处理方法
	onModifyRole:function(grid, record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载角色编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.RoleEditCtl");
		//取得角色window
		var win = ACBEE.Ext.Util.getWin('roleeditview');
		
		//保存原角色Id
		win.roleId = record.data.roleId;
		//保存父窗体表格store
		win.parentStore = grid.getStore();
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改角色 [' + record.get('roleName') + ']');
		win.show();
	},
	//删除按钮事件处理方法
	onDeleteRole:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'roleId', 'role/delRole.action', '角色');
	},
	//启用按钮事件处理方法
	onOpenStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'roleId', 'role/updateStatus.action', '角色', 1, 'status');
	},
	//禁用按钮事件处理方法
	onCloseStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'roleId', 'role/updateStatus.action', '角色', 0, 'status');
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(5 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onModifyRole(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '角色 [' + record.get('roleName') + ']';
				var id = record.get('roleId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'role/delRole.action');
			} else if(target.hasCls('btn-grantAuthor')){//赋权
				//加载赋权控制器
       			ACBEE.Ext.Util.loadController(this.application, "systemservice.GrantAuthorCtl");
				//取得授权window
				var win = ACBEE.Ext.Util.getWin('grantauthorview');
				win.setTitle('给角色 [' + record.get('roleName') + '] 赋权');
				win.roleId = record.get('roleId');
				win.show();
			} else if(target.hasCls('btn-assignUser')){//分配用户
				//加载分配用户控制器
       			ACBEE.Ext.Util.loadController(this.application, "systemservice.AssignUserCtl");
				//取得分配用户window
				var win = ACBEE.Ext.Util.getWin('assignuserview');
				win.setTitle('给角色 [' + record.get('roleName') + '] 分配用户');
				win.roleId = record.get('roleId');
				win.show();
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onModifyRole(grid, record);
		}
	}
});