/**
 * 员工信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-10
 */
Ext.define('WMS.controller.systemservice.StaffEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'systemservice.StaffEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//同员工姓名label渲染后事件
			'staffeditview label[name=lblsamename]': {
				afterrender: this.onSameNameAfterRender
			},
			//保存按钮事件
			'staffeditview button[name=btn-save]': {
				click: this.onSave
			},
	    	//窗体事件
	    	'staffeditview' : {
	    		//视图显示事件
				show: this.onShow
	    	}
		});
	},
	/**
     * 视图显示事件
     */
	onShow: function(view, eOpts) {
    	//刷新部门下拉框数据
    	view.down('combobox[name=deptId]').getStore().reload();
    	//刷新组别下拉框数据
    	view.down('combobox[name=groupId]').getStore().reload();
    	//刷新职级下拉框数据
    	view.down('combobox[name=rankId]').getStore().reload();
    },
	//同员工姓名label渲染后事件
	onSameNameAfterRender: function(label, eOpts) {
		var win = label.up('window');
		//添加单击事件
		Ext.fly(label.el).on('click', function(e, t) {
			var staffName = win.down('textfield[name=staffName]').getValue();
			win.down('textfield[name=userName]').setValue(staffName);
        });
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！", null, 300);
			return false;
		}
		
		//取得原员工Id
		var staffId = win.staffId;
		
		//提交表单内容到后台
		ACBEE.Ext.Util.submitFormData(form, 'staff/saveStaff.action', {staffId: staffId}, 
			"员工信息保存成功", "员工信息保存失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});