/**
 * 员工信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-10
 */
Ext.define('WMS.controller.systemservice.StaffSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'systemservice.StaffSearchView'
	],
	requires: [
	    'WMS.view.systemservice.StaffEditView',
	    'WMS.controller.systemservice.StaffEditCtl',
	    'WMS.view.systemservice.AssignRoleView',
	    'WMS.controller.systemservice.AssignRoleCtl',
	    'WMS.controller.common.ExcelImportCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'staffsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//查询按钮事件
	    	'staffsearchview button[name=btn-search]': {
	    		click: this.onSearchStaff
	    	},
	    	//重置按钮事件
	    	'staffsearchview button[name=btn-clear]': {
	    		click: this.onClearStaff
	    	},
        	//添加按钮事件
	    	'staffsearchview button[name=btn-add]': {
	    		click: this.onAddStaff
	    	},
	    	//删除按钮事件
	    	'staffsearchview button[name=btn-delete]': {
	    		click: this.onDeleteStaff
	    	},
	    	//导入按钮事件
	    	'staffsearchview button[name=btn-import]': {
	    		click: this.onImportStaff
	    	},
	    	//导出按钮事件
	    	'staffsearchview button[name=btn-export]': {
	    		click: this.onExportStaff
	    	},
	    	//启用按钮事件
	    	'staffsearchview button[name=btn-openStatus]': {
	    		click: this.onOpenStatus
	    	},
	    	//禁用按钮事件
	    	'staffsearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseStatus
	    	},	
	    	//表格事件
	    	'staffsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新部门下拉框数据
    	grid.down('combobox[name=deptId]').getStore().reload();
    	//刷新组别下拉框数据
    	grid.down('combobox[name=groupId]').getStore().reload();
    	//刷新职级下拉框数据
    	grid.down('combobox[name=rankId]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载部门、职级、组别下拉框数据
		var deptCbx = form.down('combobox[name=deptId]');
		var rankCbx = form.down('combobox[name=rankId]');
		var groupCbx = form.down('combobox[name=groupId]');
		
		var deptStore = deptCbx.getStore();
		var rankStore = rankCbx.getStore();
		var groupStore = groupCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的部门、职级、组别
			//修改部门store参数
			deptStore.proxy.extraParams = {
				dictType: 8,
				status: 1
			};
			//修改职级store参数
			rankStore.proxy.extraParams = {
				dictType: 9,
				status: 1
			};
			//修改组别store参数
			groupStore.proxy.extraParams = {
				dictType: 10,
				status: 1
			};
		}else{
			//修改部门store参数
			deptStore.proxy.extraParams = {
				dictType: 8,
				status: -1
			};
			//修改职级store参数
			rankStore.proxy.extraParams = {
				dictType: 9,
				status: -1
			};
			//修改组别store参数
			groupStore.proxy.extraParams = {
				dictType: 10,
				status: -1
			};
		}
		//重加载部门、职级、组别下拉框数据
		deptStore.load();
		rankStore.load();
		groupStore.load();
		
		//显示禁用项改变时，部门、职级、组别改为全部
		if(showForbidden != null){
			deptCbx.setValue(-1);
			rankCbx.setValue(-1);
			groupCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchStaff(combobox);
	},
	/**
	 * 查询或导出员工信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportStaff: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		///取得查询条件
		//员工姓名
		var staffName = grid.down('textfield[name=staffName]').getValue();
		//工号
		var jobNumber = grid.down('textfield[name=jobNumber]').getValue();
		//部门
		var deptId = grid.down('combobox[name=deptId]').getValue();
		//组别
		var groupId = grid.down('combobox[name=groupId]').getValue();
		//职级
		var rankId = grid.down('combobox[name=rankId]').getValue();
		//联系电话
		var tel = grid.down('textfield[name=tel]').getValue();
		//用户名
		var userName = grid.down('textfield[name=userName]').getValue();
		//状态
		var status = grid.down('combobox[name=status]').getValue();
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				staffName: staffName,
				jobNumber: jobNumber,
				deptId: deptId,
				groupId: groupId,
				rankId: rankId,
				tel: tel,
				userName: userName,
				status: status == -1 ? (showForbidden ? -1 : 1) : status,
				deptStatus: showForbidden ? -1 : 1,
				rankStatus: showForbidden ? -1 : 1,
				groupStatus: showForbidden ? -1 : 1
			};
			
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出员工信息
			ACBEE.Ext.Util.submitDummyForm("staff/exportStaff.action", {
				staffName: staffName,
				jobNumber: jobNumber,
				deptId: deptId,
				groupId: groupId,
				rankId: rankId,
				tel: tel,
				userName: userName,
				status: status == -1 ? (showForbidden ? -1 : 1) : status,
				deptStatus: showForbidden ? -1 : 1,
				rankStatus: showForbidden ? -1 : 1,
				groupStatus: showForbidden ? -1 : 1
	        });
		}
	},
	//查询事件处理
	onSearchStaff:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportStaff(button, 1);
	},
	//重置事件处理
	onClearStaff:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		///清空查询条件
		grid.down('textfield[name=staffName]').setValue('');
		grid.down('textfield[name=jobNumber]').setValue('');
		grid.down('combobox[name=deptId]').setValue(-1);
		grid.down('combobox[name=groupId]').setValue(-1);
		grid.down('combobox[name=rankId]').setValue(-1);
		grid.down('textfield[name=tel]').setValue('');
		grid.down('textfield[name=userName]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		grid.down('checkbox[name=showForbidden]').reset();
		
		//调用查询按钮事件
		this.onSearchStaff(button);
	},
	/**
	 * 设置密码框状态
	 * @param allowBlank 允许为空 true:可为空; false:不可为空
	 */
	setPasswordEditor: function(win, allowBlank) {
		var password = win.down('textfield[name=password]');
		var confirmPwd = win.down('textfield[name=confirmPwd]');
		
		password.allowBlank = allowBlank;
		confirmPwd.allowBlank = allowBlank;
		
		var pwdLabel = '<font class="requiredflag">* </font>密码';
		var cfmPwdLabel = '<font class="requiredflag">* </font>确认密码';
		if(allowBlank) {
			pwdLabel = '密码';
			cfmPwdLabel = '确认密码';
			
			//清空密码和确认密码框值，并清空验证提示文字
			password.setValue('');
			password.clearInvalid();
			confirmPwd.setValue('');
			confirmPwd.clearInvalid();
		}
		password.setFieldLabel(pwdLabel);
		confirmPwd.setFieldLabel(cfmPwdLabel);
	},
	//添加按钮事件处理
	onAddStaff:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载员工编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.StaffEditCtl");
		//取得员工window
		var win = ACBEE.Ext.Util.getWin('staffeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		
		//清除表单内容
		win.down('form').getForm().reset();
		//设置员工Id为空
		win.staffId = 0;
		//保存当前表格的store
		win.parentStore = button.up('grid').getStore();
		
		//设置密码和确认密码为必填项
		this.setPasswordEditor(win, false);
		
		win.setTitle('添加员工');
		win.show();
	},
	//修改按钮事件处理方法
	onModifyStaff:function(grid, record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载员工编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.StaffEditCtl");
		//取得员工window
		var win = ACBEE.Ext.Util.getWin('staffeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		
		//保存原员工Id
		win.staffId = record.data.staffId;
		//保存父窗体表格store
		win.parentStore = grid.getStore();
		
		//设置密码和确认密码为非必填项
		this.setPasswordEditor(win, true);
		
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改员工 [' + record.get('staffName') + ']');
		win.show();
	},
	//删除事件处理
	onDeleteStaff:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'staffId', 'staff/delStaff.action', '员工');
		
		
		/**
		 * 李树雪   2015-12-28
		 * bug 746
		 * code353--365
		 */
		
		
		/************************
		 * 2015-12-21
		 * bug(646)
		 * 王玉涛
		 */
		//this.onClearStaff(button);
	},
	//导入事件处理
	onImportStaff:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "staff/importStaff.action", 
			"员工信息",  button.up('grid').getStore());
	},
	//导出事件处理
	onExportStaff:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportStaff(button, 2);
	},
	//启用事件处理
	onOpenStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'staffId', 'staff/updateStatus.action', '员工', 1, 'status');
	},
	//禁用事件处理
	onCloseStatus:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'staffId', 'staff/updateStatus.action', '员工', 0, 'status');
	},
	//添加分配角色按钮事件处理
	onAssignRole:function(record){
		//加载库区编辑控制器
		ACBEE.Ext.Util.loadController(this.application, "systemservice.AssignRoleCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('assignroleview');
		win.setTitle('给用户 [' + record.get('staffName') + '] 分配角色');
		win.staffId = record.get('staffId');
		win.show();
	},
	//添加查看权限按钮事件处理
	onViewAuthor:function(record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载显示权限控制器
		ACBEE.Ext.Util.loadController(this.application, "systemservice.ViewAuthorCtl");
		//显示显示权限window
		var win = ACBEE.Ext.Util.getWin('viewauthorview');
		win.setTitle('用户 [' + record.get('staffName') + '] 拥有的权限');
		win.staffId = record.get('staffId');
		win.show();
	},
	//显示详情事件
	onShowInfo : function(grid, record){
		//加载员工编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "systemservice.StaffEditCtl");
		//取得员工window
		var win = ACBEE.Ext.Util.getWin('staffeditview');
		//设置编辑框不可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), true);
		//设置密码和确认密码为非必填项
		this.setPasswordEditor(win, true);
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('员工 [' + record.get('staffName') + '] 详细信息');
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(13 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onModifyStaff(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '员工 [' + record.get('staffName') + ']';
				var id = record.get('staffId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'staff/delStaff.action');
			} else if(target.hasCls('btn-assignRole')){//点击了分配角色
				this.onAssignRole(record);
			} else if(target.hasCls('btn-viewAuthor')){//点击了查看权限
				this.onViewAuthor(record);
			}  else if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onModifyStaff(grid, record);
		}
	}
});