/**
 * 查看权限controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-23
 */
Ext.define('WMS.controller.systemservice.ViewAuthorCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'systemservice.ViewAuthorView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//窗体事件
	    	'viewauthorview': {
	    		show: this.onShow
	    	}
		});
	},
	/**
     * 窗体显示事件处理方法
     */
    onShow: function(win, eOpts) {
    	//创建模块权限树store
    	var authorStore = Ext.create('WMS.store.menufunction.MenuStr', {
    		url: 'staff/getUserAuthor.action',
    		params: {
            	userId: win.staffId
            }
    	});
    	authorStore.load();
		
		var tree = win.down('treepanel');
		//绑定模块权限树的store
		tree.bindStore(authorStore);
		
		//监听store的加载事件
		authorStore.on("load", function(store, records, successful, eOpts){
			//取得根结点
			var rootNode = tree.getRootNode();
			if(rootNode.hasChildNodes()) {
				//展开根结点
				rootNode.expand();
				
				//遍历，展开二级节点
				rootNode.eachChild(function(child){
					child.expand();
        		});
			} else {
				ACBEE.Ext.Util.showAlertBox("用户没有任何功能权限！", null, 300, function() {
					win.close();
				});
			}
		});
    }
});