/**
 * 供应商列表controller.
 * @author 高元称
 * @version 1.0.0, 2015-08-26
 */
Ext.define('WMS.controller.transferstock.SupplierListViewCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'transferstock.SupplierListView',
		'transferstock.TransferStockDemandBillEditView'
	],
	stores:[
	    'WMS.store.stock.StockViewStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			// 确定按钮事件
			'supplierlistview  button[name=btn-sure]': {
				click: this.onSure
			},
			'supplierlistview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'stock/getSupplierList.action',
			params: {
				goodsId: win.goodsId,
			    productBatch : win.productBatch
			}
		});
		win.down('grid').on("itemdblclick",function(grid, record, item, index, e, eOpts){
		 	var store = Ext.getCmp(win.editView).down('grid').getStore();
		 	store.getAt(win.rowIndex).set('supplierName',record.data.supplierName);
			store.getAt(win.rowIndex).set('supplierId',record.data.supplierId);
			win.close();
		 });
	},
	//确定按钮事件
	onSure: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var store = Ext.getCmp(win.editView).down('grid').getStore();
		var records=grid.getSelectionModel().getSelection(); 
		if(records.length > 1){
			ACBEE.Ext.Util.showAlertBox("只能选择一个供应商！！！", null, 300);
		} else if (records.length == 0){
			ACBEE.Ext.Util.showAlertBox("你没有选择任何一个供应商！！！", null, 300);
		} else {
			store.getAt(win.rowIndex).set('supplierName',records[0].data.supplierName);
			store.getAt(win.rowIndex).set('supplierId',records[0].data.supplierId);
			win.close();
		}
	}
});