/**
 * 预约调拨信息编辑controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.transferstock.TransferStockDemandBillEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'transferstock.TransferStockDemandBillEditView',
		'transferstock.SupplierListView'
	],
	stores:[
	    'WMS.store.transferstock.TransferStockDemandBillItemGoodsViewStr',
	    'WMS.store.stock.StockViewStr',
	    'WMS.store.common.StockSupplierStr'
	],
	requires: [
	    'WMS.controller.transferstock.SupplierListViewCtl',
	    'WMS.view.transferstock.SupplierListView'
   	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//调出库区号改变事件
	    	'transferstockdemandbilleditview combobox[name=outAreaId]': {
	    		change: this.onOutAreaCodeChange
	    	},		
			//调入库区号改变事件
	    	'transferstockdemandbilleditview combobox[name=inAreaId]': {
	    		change: this.onInAreaCodeChange
	    	},
			//保存按钮事件
			'transferstockdemandbilleditview  button[name=btn-save]': {
				click: this.onSaveTransferStock
			},
			//打印按钮事件
			'transferstockdemandbilleditview  button[name=btn-print]': {
				click: this.onPrint
			},
			//添加按钮事件
			'transferstockdemandbilleditview  button[name=btn-add]': {
				click: this.onAddTransferStock
			},
			//导入按钮事件
			'transferstockdemandbilleditview  button[name=btn-import]': {
				click: this.onImport
			},
			//导出按钮事件
			'transferstockdemandbilleditview  button[name=btn-export]': {
				click: this.onExport
			},
			//删除按钮事件
			'transferstockdemandbilleditview  button[name=btn-delete]': {
				click: this.onDeleteTransferStock
			},
			'transferstockdemandbilleditview':{
				beforeshow: this.OnBeforeShow
			},
			'transferstockdemandbilleditview grid':{
	    		cellclick: this.onGridEditCellClick
			},
			/**
    		 * @author 李树雪 2015年12月24日 下午15.38
    		 * @bug 708
    		 * @code:63-79
    		 */
			//调出库位号展开,改变和聚焦事件
	    	'transferstockdemandbilleditview combobox[name=outLocationId]': {
	    		expand: this.onOutLocationIdExpand,
	    		change: this.onOutLocationIdChange,
	    		focus: this.onOutLocationIdFocus,
	    	},
	    	//调入库位号展开,改变和聚焦事件
	    	'transferstockdemandbilleditview combobox[name=inLocationId]': {
	    		expand: this.onInLocationIdExpand,
	    		change: this.onInLocationIdChange,
	    		focus: this.onInLocationIdFocus,
	    	}
		});
	},
	OnBeforeShow : function(win, e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'transferstock/searchTransferstockDemandBillItemList.action',
			params: {transferstockDemandBillId: win.oldTransferstockDemandBillId}
		});
		
		//编制调拨需求单
		if(0 == win.oldTransferstockDemandBillId) {
			//获取服务器时间，设置预约日期和计划到货时间
			ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
				if(undefined != result && null != result) {
					win.down('datefield[name=appointmentDate]').setValue(Ext.Date.format(new Date(result), "Y-m-d"));
				}
		  	});
		}
		
		//刷新调拨原因拉框数据
		win.down('combobox[name=transferCause]').getStore().reload();
    	//刷新调拨出-库区下拉框数据
		win.down('combobox[name=outAreaId]').getStore().reload();
    	//刷新调拨出-库位号下拉框数据
		win.down('combobox[name=outLocationId]').getStore().reload();
    	//刷新调拨入-库区下拉框数据
		win.down('combobox[name=inAreaId]').getStore().reload();
    	//刷新调拨入-库位号下拉框数据
		win.down('combobox[name=inLocationId]').getStore().reload();
	},
	/**
	 * 调出库区号改变事件
	 */
	onOutAreaCodeChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var outAreaId = combobox.getValue();
		var areaStore = combobox.getStore();
		
		//从调出库区中获取库区性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(areaStore, 'areaId', outAreaId, '未知库区性质', 'areaNature');
        form.down('displayfield[name=outAreaNature1]').setValue(t==1?'可用':t==0?'不可用':t);
        
		var outLocationId = form.down('combobox[name=outLocationId]');
		var store1 = outLocationId.getStore();
		/**
		 * 李树雪2015.12.29
		 * bug737
		 * code:130-132
		 */
		if(outAreaId == null){
			outLocationId.setValue('');
		}
		store1.proxy.extraParams = {
			areaId: outAreaId,
    	 	areaNature:-1,
    	 	status : 1
		};
		store1.load();
	},
	
	/**
	 * 调入库区号改变事件
	 */
	onInAreaCodeChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var inAreaId = combobox.getValue();
		var areaStore = combobox.getStore();
		
		//从调入库区中获取库区性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(areaStore, 'areaId', inAreaId, '未知库区性质', 'areaNature');
        form.down('displayfield[name=inAreaNature2]').setValue(t==1?'可用':t==0?'不可用':t);
        
		var inLocationId = form.down('combobox[name=inLocationId]');
		var store1 = inLocationId.getStore();
		/**
		 * 李树雪2015.12.29
		 * bug737
		 * code:161-163
		 */
		if(inAreaId == null){
			inLocationId.setValue('');
		}
		store1.proxy.extraParams = {
				areaId: inAreaId,
        	 	areaNature:-1,
        	 	status : 1
			};
		store1.load();
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		if(null == store || undefined == store || 0 == store.getCount()) {
			ACBEE.Ext.Util.showAlertBox("请添加至少一条货物明细", null, 300);
			return false;
		}
		
		var goodsCode;
		var supplierId;
		var supplierName;
		var planArrivalQuantity;
		var productBatch;
		//货物号与供应商拼接的字符串
		var goodsLinkSupplierName = "";
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			goodsCode = store.getAt(i).get('goodsCode');
			productBatch = store.getAt(i).get('productBatch');
			if("" == goodsCode) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物号不能为空", null, 300);
				return false;
			}
			planTransferQuantity = store.getAt(i).get('planTransferQuantity');
				if("" == planTransferQuantity) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的计划调拨数量不能为空", null, 300);
				return false;
			}
			
			supplierId = store.getAt(i).get('supplierId');
			if("" == supplierId) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的供应商不能为空", null, 300);
				return false;
			}
			supplierName = store.getAt(i).get('supplierName');
	
			for(var j=0; j<i;j++){
				if(store.getAt(j).get('goodsCode') == store.getAt(i).get('goodsCode') && store.getAt(j).get('supplierName') == store.getAt(i).get('supplierName')){
					ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物编号重复", null, 300);
					return false;
				}
			}
		}
		return true;
	},
	//保存按钮事件
	onSaveTransferStock: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}

		var hasError = false;
		//获取服务器时间
		ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
			if(undefined != result && null != result) {
				//取得当前服务器日期
				var curDate = Ext.Date.format(new Date(result), "Y-m-d");
				var appointmentDate = win.down('datefield[name=appointmentDate]').getValue();
				appointmentDate = Ext.Date.format(new Date(appointmentDate), "Y-m-d");
				if(appointmentDate < curDate) {
					ACBEE.Ext.Util.showAlertBox("预约日期不能早于当前日期[" + curDate + "]！", null, 300);
					hasError = true;
					return false;
				}
				
				//取得当前服务器时间
				var curTime = Ext.Date.format(new Date(result), "Y-m-d H:i:s");
				var planArrivalTime = win.down('datetimefield[name=planTransferTime]').getValue();
				planArrivalTime = Ext.Date.format(new Date(planArrivalTime), "Y-m-d H:i:s");
				if(planArrivalTime < curTime) {
					ACBEE.Ext.Util.showAlertBox("计划调拨时间不能早于当前时间[" + curTime + "]！", null, 300);
					hasError = true;
					return false;
				}
			} else {
				ACBEE.Ext.Util.showAlertBox("无法取得服务器时间，保存调拨预约单失败！", null, 300);
				hasError = true;
				return false;
			} 
				
	  	});
		
		if(hasError) {
			return false;
		}
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}
		
		var store = grid.getStore();
		var totalQuantity = 0;
		var totalPrice = 0.0;
		for (var i = 0; i < store.getCount(); i++) {
			price = store.getAt(i).get('price');
			planTransferQuantity = store.getAt(i).get('planTransferQuantity');
			totalQuantity = totalQuantity * 1 + planTransferQuantity * 1;
			totalPrice = totalPrice * 1 + ((price * 1) * (planTransferQuantity * 1));
		}
		
		//验证同一库区同一库位不可调拨
	    //获取调拨出、调拨入库区
		var outAreaIndex = form.down('combobox[name=outAreaId]').getValue();
		var inAreaIndex = form.down('combobox[name=inAreaId]').getValue()
		//获取调拨出、调拨入库位
		var outLocationIndex = form.down('combobox[name=outLocationId]').getValue();
		var inLocationIndex = form.down('combobox[name=inLocationId]').getValue()
		if(outAreaIndex == inAreaIndex){
			if(outLocationIndex == inLocationIndex){
				ACBEE.Ext.Util.showAlertBox("同一库区下的同一库位不能调拨", null, 400);
				return false;
			}
		}
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldTransferstockDemandBillId=win.oldTransferstockDemandBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'transferstock/saveTransferstockDemandBill.action', {
			oldTransferstockDemandBillId: oldTransferstockDemandBillId,
			goods:goods,
			totalPrice:totalPrice,
			totalQuantity:totalQuantity,
			flag : 0
		}, "预约调拨需求单生成成功", "预约调拨需求单生成失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	},
	//删除按钮事件
	onDeleteTransferStock: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var records=grid.getSelectionModel().getSelection(); 
		for(var i=0;i<records.length;i++){
			grid.getStore().remove(records[i]);
		}
		grid.view.refresh();
	},
	//打印按钮事件
	onPrint : function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		ACBEE.Ext.Util.showReport({
			report: 'transferStockDemandBill',
			transferDemanderBillId: win.oldTransferstockDemandBillId
		});
	},
	/**
	 * 处理导入成功的数据
	 */
	onDealImportSucceedData: function(store, successList) {
		if(null == successList || undefined == successList) {
			return;
		}
		
		var record;
		var index = -1;
		var msg = '';
		for(var i=0;i<successList.length;i++){
			//查找原store中是否已经存在货物号
			index = store.find('goodsCode', successList[i].goodsCode);
        	if(-1 != index) {
        		if("" != msg) {
        			msg += "，";
        		}
        		msg += successList[i].goodsCode;
        		continue;
        	}
			
			record = Ext.create('WMS.model.transferstock.TransferstockDemandBillItemGridMdl', {
				goodsCode: successList[i].goodsCode,
				goodsName: successList[i].goodsName,
				goodsId: successList[i].goodsId,
				specs: successList[i].specs,
				productBatch: successList[i].productBatch,
				planTransferQuantity: successList[i].planTransferQuantity,
				price: successList[i].price,
				supplierId: successList[i].supplierId,
				supplierName: successList[i].supplierName
			});
			store.add(record);
		}
		
		if("" != msg) {
			msg = "货物号为：［" + msg + "］的货物已经存在表格中，不再追加！";
			ACBEE.Ext.Util.showAlertBox(msg, null, 400);
		}
	},
	//导入按钮事件
	onImport: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "transferstock/importTransferstockDemandBill.action", 
			"调拨需求单-货物明细信息",  button.up('grid').getStore(), this.onDealImportSucceedData, {
			refreshGrid: false
		});
	},
	//导出按钮事件
	onExport: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//取得预约出库store
		var store = grid.getStore();
		//导出预约出库信息
		ACBEE.Ext.Util.exportExcelFile(grid, "调拨需求单-货物明细信息",['goodsId']);
	},
	//添加按钮事件
	onAddTransferStock: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var store = grid.getStore();
		var record = Ext.create('WMS.model.transferstock.TransferstockDemandBillItemGridMdl');
		store.add(record);
	},
	//弹出供应商列表
	onGridEditCellClick : function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
		if(7 == cellIndex){
			if(grid.up('window').status == 0 || undefined == grid.up('window').status){
				//加载供应商列表控制器
		        ACBEE.Ext.Util.loadController(this.application, "transferstock.SupplierListViewCtl");
				//显示供应商列表window
				var win = ACBEE.Ext.Util.getWin('supplierlistview');
				win.goodsId = record.data.goodsId;
				win.productBatch = record.data.productBatch;
				win.rowIndex = rowIndex;
				win.editView ="transferstockdemandbilleditview";
				win.showAt(e.getXY());
			}
		}
		if(3 == cellIndex){
			if(grid.up('window').status == 0 || undefined == grid.up('window').status){
				//加载生产批号列表控制器
			    ACBEE.Ext.Util.loadController(this.application, "cancelstock.ProductBatchViewCtl");
				//显示生产批号列表window
				var win = ACBEE.Ext.Util.getWin('productbatchview');
				win.goodsId = record.data.goodsId;
				win.supplierId =record.data.supplierId;
				win.rowIndex = rowIndex;
				win.editView = "transferstockdemandbilleditview";
				win.showAt(e.getXY());
			}
		}
	},
	/**
	 * @author 李树雪 2015年12月24日 下午15.38
	 * @bug 708
	 * @code:453-510
	 */
	/**
	 * 调出库位号展开事件
	 */
	onOutLocationIdExpand :function(combobox, record, value){
		if(combobox.up('form').down('combobox[name=outAreaId]').getValue() == null){
			ACBEE.Ext.Util.showAlertBox("请先选择库区，再选择库位号！", null, 320);
			return false;
		}
	},
	/**
	 * 调出库位号改变事件
	 */
	onOutLocationIdChange :function(combobox, record, value){
		//从调出库位号中获取库位性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(combobox.getStore(), 'locationId', combobox.getValue(), '未知库区性质', 'natureName');
		combobox.up('form').down('displayfield[name=outLocationNature1]').setValue(t);
		return false;
	},
	/**
	 * 调出库位聚焦事件
	 */
	onOutLocationIdFocus :function(combobox, record, value){
		if(combobox.up('form').down('combobox[name=outAreaId]').getValue() == null){
			ACBEE.Ext.Util.showAlertBox("请先选择库区，再选择库位号！", null, 320);
			return false;
		}
	},
	/**
	 * 调入库位号展开事件
	 */
	onInLocationIdExpand :function(combobox, record, value){
		if(combobox.up('form').down('combobox[name=inAreaId]').getValue() == null){
			ACBEE.Ext.Util.showAlertBox("请先选择库区，再选择库位号！", null, 320);
			return false;
		}
	},
	/**
	 * 调入库位号改变事件
	 */
	onInLocationIdChange: function(combobox, record, value){
		//从调入库位号中获取库位性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(combobox.getStore(), 'locationId', combobox.getValue(), '未知库区性质', 'natureName');
		combobox.up('form').down('displayfield[name=inLocationNature2]').setValue(t);
		return false;
	},
	/**
	 * 调入库位号聚焦事件
	 */
	onInLocationIdFocus :function(combobox, record, value){
		if(combobox.up('form').down('combobox[name=inAreaId]').getValue() == null){
			ACBEE.Ext.Util.showAlertBox("请先选择库区，再选择库位号！", null, 320);
			return false;
		}
	}
});