/**
 * 预约调拨信息管理controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.transferstock.TransferStockDemandBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'transferstock.TransferStockDemandBillSearchView'
	],
	requires: [
   	    'WMS.view.transferstock.TransferStockDemandBillEditView',
   	    'WMS.controller.transferstock.TransferStockDemandBillEditCtl'
    ],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'transferstockdemandbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//调出库区号改变事件
	    	'transferstockdemandbillsearchview combobox[name=outAreaId]': {
	    		change: this.onOutAreaCodeChange
	    	},
	    	//调入库区号改变事件
	    	'transferstockdemandbillsearchview combobox[name=inAreaId]': {
	    		change: this.onInAreaCodeChange
	    	},
        	//编制按钮事件
	    	'transferstockdemandbillsearchview button[name=btn-drawUp]': {
	    		click: this.onAddTransferStockDemandBill
	    	},
	    	//删除按钮事件
	    	'transferstockdemandbillsearchview button[name=btn-delete]': {
	    		click: this.onDeleteTransferStockDemandBill
	    	},
	    	//查询按钮事件
	    	'transferstockdemandbillsearchview button[name=btn-search]': {
	    		click: this.onSearchTransferStockDemandBill
	    	},
	    	//清空按钮事件
	    	'transferstockdemandbillsearchview button[name=btn-clear]': {
	    		click: this.onClearTransferStockDemandBill
	    	},
	    	//表格事件
	    	'transferstockdemandbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	 /**
	 * combobox改变事件
	 */
 	onComboboxChange : function (combobox,showLableName,url){
		var Id = combobox.getValue();
		var cbx = combobox.up('form').down('combobox[name='+showLableName+']');
		if(Id!=-1){
			ACBEE.Ext.Util.ajaxRequest(url,{Id : Id},function(result){
		  		if(null != cbx){
		  			cbx.setValue(result.map.areaNature);
		  		}
		  	});
		} else {
			cbx.setValue('-1');
		}
	},
	/**
	 * 调出库区号改变事件
	 */
	onOutAreaCodeChange: function(combobox, record, value){
		this.onComboboxChange(combobox,"outAreaNature","warehouseArea/getAreaNature.action");
	},
	/**
	 * 调入库区号改变事件
	 */
	onInAreaCodeChange: function(combobox, record, value){
		this.onComboboxChange(combobox,"inAreaNature","warehouseArea/getAreaNature.action");
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新调拨原因拉框数据
    	grid.down('combobox[name=transferCause]').getStore().reload();
    	//刷新调拨出-库区下拉框数据
    	grid.down('combobox[name=outAreaId]').getStore().reload();
    	//刷新调拨入-库区下拉框数据
    	grid.down('combobox[name=inAreaId]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商、退库原因下拉框数据
		var transferCauseCbx = form.down('combobox[name=transferCause]');
		var outAreaCbx = form.down('combobox[name=outAreaId]');
		var inAreaCbx = form.down('combobox[name=inAreaId]');
		var transferCauseStore = transferCauseCbx.getStore();
		var outAreaStore = outAreaCbx.getStore();
		var inAreaStore = inAreaCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的调拨原因、调拨出-库区号、调拨入-库区号
			//修改调拨原因store参数
			transferCauseStore.proxy.extraParams = {
				dictType: 6,
        		status: 1
			};
			//修改调拨出-库区号store参数
			outAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : 1
			};
			//修改调拨入-库区号store参数
			inAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : 1
			};
		}else{
			//修改调拨原因store参数
			transferCauseStore.proxy.extraParams = {
				dictType: 6,
        		status: -1
			};
			//修改调拨出-库区号store参数
			outAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : -1
			};
			//修改调拨入-库区号store参数
			inAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : -1
			};
		}
		//重加载库区下拉框数据
		transferCauseStore.load();
		outAreaStore.load();
		inAreaStore.load();
		
		//显示禁用项改变时，供应商改为全部
		if(showForbidden != null){
			transferCauseCbx.setValue(-1);
			outAreaCbx.setValue(-1);
			inAreaCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchTransferStockDemandBill(combobox);
	},
	//编制按钮事件处理
	onAddTransferStockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载预约调拨编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "transferstock.TransferStockDemandBillEditCtl");
		//显示预约调拨window
		var win = ACBEE.Ext.Util.getWin('transferstockdemandbilleditview');
		//清除表单内容
	    win.down('form').getForm().reset();
  	  	var store=win.down('grid').getStore();
  	  	if(store.getCount()>0){
  	  		store.removeAll();
  	  	}
		//设置调拨需求单Id为零
	  	win.oldTransferstockDemandBillId=0;
	  	//生成调拨需求号
	  	//得到调拨需求号对象
	  	var demandNo = win.down('textfield[name=demandNo]');
	  	ACBEE.Ext.Util.ajaxRequest("transferstock/generateTransferstockNum.action",null,function(result){
	  		if(null != demandNo){
	  			demandNo.setValue(result.map.transferstockNum);
	  		}
	  	});
	  	var save=win.down('button[name=btn-save]');
		var add=win.down('button[name=btn-add]');
		var deleteData=win.down('button[name=btn-delete]');
		var importData=win.down('button[name=btn-import]');
		ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), false);
		win.status = undefined;
		//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
	  	win.setTitle('预约调拨信息编辑');
	  	win.show();
	},
	//删除事件处理
	onDeleteTransferStockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
			
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'transferstockDemandBillId', 'transferstock/deltransferstockDemandBill.action', '调拨需求单');
	},
	//查询事件处理
	onSearchTransferStockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var transferDemandBillGrid = button.up('grid');
		//取得表单对象
		var form = transferDemandBillGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得调拨需求号
		var demandNo = transferDemandBillGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(transferDemandBillGrid.down('datefield[name=transferBillBeginDate]').getValue()==null)
			var transferBillBeginDate=null;
	    else
		    transferBillBeginDate = Ext.Date.format(new Date(transferDemandBillGrid.down('datefield[name=transferBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(transferDemandBillGrid.down('datefield[name=transferBillEndDate]').getValue()==null)
			var transferBillEndDate=null;
	    else    
		    transferBillEndDate = Ext.Date.format(new Date(transferDemandBillGrid.down('datefield[name=transferBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划调拨开始
		if(transferDemandBillGrid.down('datetimefield[name=planTransferBeginTime]').getValue()==null)
	    	var planTransferBeginTime=null;
	    else
			planTransferBeginTime = Ext.Date.format(new Date(transferDemandBillGrid.down('datetimefield[name=planTransferBeginTime]').getValue()),'Y-m-d H:i:s');
		//取得计划调拨结束时间
	    if(transferDemandBillGrid.down('datetimefield[name=planTransferEndTime]').getValue()==null)
    		var planTransferEndTime=null;
    	else
			planTransferEndTime = Ext.Date.format(new Date(transferDemandBillGrid.down('datetimefield[name=planTransferEndTime]').getValue()),'Y-m-d H:i:s');
		//取得调拨原因
		var transferCause = transferDemandBillGrid.down('combobox[name=transferCause]').getValue();
		//取得调拨出-库区号
		var outAreaId = transferDemandBillGrid.down('combobox[name=outAreaId]').getValue();
		//取得调拨出-库区性质
		var outAreaNature = transferDemandBillGrid.down('combobox[name=outAreaNature]').getValue();
		//取得调拨状态
		var status = transferDemandBillGrid.down('combobox[name=status]').getValue();
		//取得调拨入-库区号
		var inAreaId = transferDemandBillGrid.down('combobox[name=inAreaId]').getValue();
		//取得调拨入-库区性质
		var inAreaNature = transferDemandBillGrid.down('combobox[name=inAreaNature]').getValue();
		//取得显示禁用项
	    var showForbidden=transferDemandBillGrid.down('checkbox[name=showForbidden]').getValue();

	    //取得入库需求单的store
		var store = transferDemandBillGrid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			transferCause : transferCause,
			outAreaId : outAreaId,
			outAreaNature : outAreaNature,
			status : status,
			inAreaId : inAreaId,
			inAreaNature : inAreaNature,
			transferBillBeginDate : transferBillBeginDate,
			transferBillEndDate : transferBillEndDate,
			planTransferBeginTime : planTransferBeginTime,
			planTransferEndTime : planTransferEndTime,
			inAreaStatus: showForbidden ? -1 : 1,
			outAreaStatus: showForbidden ? -1 : 1,
			causeStatus: showForbidden ? -1 : 1,
			flag : 0
		};
		store.loadPage(1);
	},
	//清空事件处理
	onClearTransferStockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var transferDemandBillGrid = button.up('grid');
		///清空查询条件
		transferDemandBillGrid.down('textfield[name=demandNo]').setValue('');
		transferDemandBillGrid.down('datefield[name=transferBillBeginDate]').setValue('');
		transferDemandBillGrid.down('datefield[name=transferBillEndDate]').setValue('');
		transferDemandBillGrid.down('datetimefield[name=planTransferBeginTime]').setValue('');
	    transferDemandBillGrid.down('datetimefield[name=planTransferEndTime]').setValue('');
		transferDemandBillGrid.down('combobox[name=status]').setValue('-1');
		transferDemandBillGrid.down('combobox[name=outAreaId]').setValue(-1);
		transferDemandBillGrid.down('combobox[name=outAreaNature]').setValue('-1');
		transferDemandBillGrid.down('combobox[name=inAreaId]').setValue(-1);
		transferDemandBillGrid.down('combobox[name=inAreaNature]').setValue('-1');
		transferDemandBillGrid.down('combobox[name=transferCause]').setValue(-1);
		transferDemandBillGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchTransferStockDemandBill(button);
	},
	//修改按钮事件
	onUpdateTransferDemandBill:function (grid,record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载预约调拨编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "transferstock.TransferStockDemandBillEditCtl");
		//显示预约调拨window
		var win = ACBEE.Ext.Util.getWin('transferstockdemandbilleditview');
		//保存原入库需求单Id
	  	win.oldTransferstockDemandBillId=record.data.transferstockDemandBillId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	var save=win.down('button[name=btn-save]');
		var add=win.down('button[name=btn-add]');
		var deleteData=win.down('button[name=btn-delete]');
		var importData=win.down('button[name=btn-import]');
		if(record.get('status') !=0){
			ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), true);
			win.status = record.get('status');
		} else {
			ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), false);
			win.status = record.get('status');
		}
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改调拨需求单 [' + record.get('demandNo') + ']');
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(20 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateTransferDemandBill(grid,record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '调拨需求单 [' + record.get('demandNo') + ']';
				var id = record.get('transferstockDemandBillId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'transferstock/deltransferstockDemandBill.action');
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateTransferDemandBill(grid, record);
		}
	}
});