/**
 * 调拨操作信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.transferstock.TransferstockBillEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'transferstock.TransferstockBillEditView'
	],
	stores:[
	    'WMS.store.transferstock.TransferStockDemandBillItemGoodsViewStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//调出库区号改变事件
	    	'transferstockbilleditview combobox[name=outAreaId]': {
	    		change: this.onOutAreaCodeChange
	    	},
	    	//调出库位号改变事件
	    	'transferstockbilleditview combobox[name=outLocationId]': {
	    		change: this.onOutLocationIdChange
	    	},
	    	'transferstockbilleditview combobox[name=inAreaId]': {
	    		change: this.onInAreaCodeChange
	    	},
	    	//调入库位号改变事件
	    	'transferstockdemandbillitemeditview combobox[name=inLocationId]': {
	    		change: this.onInLocationIdChange
	    	},
			//保存按钮事件
			'transferstockbilleditview  button[name=btn-save]': {
				click: this.onSave
			},
			'transferstockbilleditview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	OnBeforeShow : function(win, e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'transferstock/searchTransferstockDemandBillItemList.action',
			params: {transferstockDemandBillId: win.oldTransferstockDemandBillId}
		});
		
		//刷新实际调拨组下拉框数据
		win.down('combobox[name=actualTransferstockGroup]').getStore().reload();
    	//刷新调拨出-库区下拉框数据
		win.down('combobox[name=outAreaId]').getStore().reload();
    	//刷新调拨出-库位号下拉框数据
		win.down('combobox[name=outLocationId]').getStore().reload();
    	//刷新调拨入-库区下拉框数据
		win.down('combobox[name=inAreaId]').getStore().reload();
    	//刷新调拨入-库位号下拉框数据
		win.down('combobox[name=inLocationId]').getStore().reload();
	},
	/**
	 * 调出库区号改变事件
	 */
	onOutAreaCodeChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var outAreaId = combobox.getValue();
		var areaStore = combobox.getStore();
		
		//从调入库区中获取库区性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(areaStore, 'areaId', outAreaId, '未知库区性质', 'areaNature');
        form.down('displayfield[name=outAreaNature]').setValue(t);
        
		var outLocationId = form.down('combobox[name=outLocationId]');
		var store1 = outLocationId.getStore();
		if(outLocationId != null){
			outLocationId.setValue('');
		}
		store1.on("beforeload", function(store, operation, eOpts){
			Ext.apply(store.proxy.extraParams, {
				areaId: outAreaId,
        	 	areaNature:-1,
        	 	status : 1
			});
		});
		store1.load();
	},
	/**
	 * 调出库位号改变事件
	 */
	onOutLocationIdChange: function(combobox, record, value){
		//从调入库位号中获取库位性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(combobox.getStore(), 'locationId', combobox.getValue(), '未知库位性质', 'natureName');
		combobox.up('form').down('displayfield[name=outLocationNature]').setValue(t);
	},
	/**
	 * 调入库区号改变事件
	 */
	onInAreaCodeChange: function(combobox, record, value){
		var form = combobox.up('form');
		//得到库区ID
		var inAreaId = combobox.getValue();
		var areaStore = combobox.getStore();
		
		//从调入库区中获取库区性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(areaStore, 'areaId', inAreaId, '未知库区性质', 'areaNature');
        form.down('displayfield[name=inAreaNature]').setValue(t);
        
		var inLocationId = form.down('combobox[name=inLocationId]');
		var store1 = inLocationId.getStore();
		if(inLocationId != null){
			inLocationId.setValue('');
		}
		store1.on("beforeload", function(store, operation, eOpts){
			Ext.apply(store.proxy.extraParams, {
				areaId: inAreaId,
        	 	areaNature:-1,
        	 	status : 1
			});
		});
		store1.load();
	},
	/**
	 * 调入库位号改变事件
	 */
	onInLocationIdChange: function(combobox, record, value){
		//从调入库位号中获取库位性质
		var t = ACBEE.Ext.Util.getPropertyFromStore(combobox.getStore(), 'locationId', combobox.getValue(), '未知库位性质', 'natureName');
		combobox.up('form').down('displayfield[name=inLocationNature]').setValue(t);
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}
		var hasError = false;
		//获取服务器时间
		ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
			if(undefined != result && null != result) {
				//取得当前服务器日期
			var curDate = Ext.Date.format(new Date(result), "Y-m-d");
				//获取预约日期
			var appointmentDate = win.down('displayfield[name=appointmentDate]').getValue();
			appointmentDate =  Ext.Date.format(new Date(appointmentDate), "Y-m-d");
		
			//获取实际调拨时间
			var actualTransferTime = win.down('datefield[name=actualTransferTime]').getValue();
			actualTransferTime = Ext.Date.format(new Date(actualTransferTime), "Y-m-d");
		
			if(actualTransferTime > curDate) {
				ACBEE.Ext.Util.showAlertBox("实际调拨时间不能晚于当前日期[" + curDate + "]！", null, 300);
				hasError = true;
				return false;
		}
			if(actualTransferTime < appointmentDate) {
				ACBEE.Ext.Util.showAlertBox("实际调拨日期不能早于预约日期[" + appointmentDate + "]！", null, 300);
				hasError = true;
				return false;
		}
			}
			});
		if(hasError) {
			return false;
		}
		
		var store = grid.getStore();
		var totalQuantity = 0;
		var totalPrice = 0.0;
		for (var i = 0; i < store.getCount(); i++) {
			price = store.getAt(i).get('price');
			planTransferQuantity = store.getAt(i).get('planTransferQuantity');
			totalQuantity = totalQuantity * 1 + planTransferQuantity * 1;
			totalPrice = totalPrice * 1 + ((price * 1) * (planTransferQuantity * 1));
		}
		
		//验证同一库区同一库位不可调拨
	    //获取调拨出、调拨入库区
		var outAreaIndex = form.down('combobox[name=outAreaId]').getValue();
		var inAreaIndex = form.down('combobox[name=inAreaId]').getValue()
		//获取调拨出、调拨入库位
		var outLocationIndex = form.down('combobox[name=outLocationId]').getValue();
		var inLocationIndex = form.down('combobox[name=inLocationId]').getValue()
		if(outAreaIndex == inAreaIndex){
			if(outLocationIndex == inLocationIndex){
				ACBEE.Ext.Util.showAlertBox("同一库区下的同一库位不能调拨", null, 400);
				return false;
			}
		}
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldTransferstockDemandBillId=win.oldTransferstockDemandBillId;
		//提交表单数据到后台saveTransferStockDemandBill
		ACBEE.Ext.Util.submitFormData(form, 'transferstock/saveTransferstockDemandBill.action', {
			oldTransferstockDemandBillId: oldTransferstockDemandBillId,
			goods:goods,
			totalPrice:totalPrice,
			totalQuantity:totalQuantity,
			flag : 1
		}, "调拨操作成功", "调拨操作失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		var actualTransferQuantity;
		var status;
		//未上架、实际调拨数量为空个数
		var downCount = 0;
		//未上架个数
		 var count = 0;
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			actualTransferQuantity = store.getAt(i).get('actualTransferQuantity');
			status = store.getAt(i).get('status');
			if (status==0){
				count++;
			}
		    if(undefined == actualTransferQuantity && status==0){//未上架的并且实际数量为空
		   		downCount++;
		    }
		}
		if(downCount == count){
			ACBEE.Ext.Util.showAlertBox("必须下架一批货物并且填写调拨数量！", null, 300);
			return false;
		} 
		return true;
	}
});