/**
 * 调拨操作信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.transferstock.TransferstockBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'transferstock.TransferstockBillSearchView'
	],
	requires: [
	    'WMS.view.transferstock.TransferstockBillEditView',
	    'WMS.controller.transferstock.TransferstockBillEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'transferstockbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//调出库区号改变事件
	    	'transferstockbillsearchview combobox[name=outAreaId]': {
	    		change: this.onOutAreaCodeChange
	    	},
	    	//调入库区号改变事件
	    	'transferstockbillsearchview combobox[name=inAreaId]': {
	    		change: this.onInAreaCodeChange
	    	},
	    	//查询按钮事件
	    	'transferstockbillsearchview button[name=btn-search]': {
	    		click: this.onSearchTransferstockDemandBillItem
	    	},
	    	//清空按钮事件
	    	'transferstockbillsearchview button[name=btn-clear]': {
	    		click: this.onClearTransferstockDemandBillItem
	    	},
	    	//调拨按钮事件
	    	'transferstockbilleditview button[name=btn-transfer]': {
	    		click: this.showTransfer
	    	},
	    	//表格事件
	    	'transferstockbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新调拨原因拉框数据
    	grid.down('combobox[name=transferCause]').getStore().reload();
    	//刷新调拨出-库区下拉框数据
    	grid.down('combobox[name=outAreaId]').getStore().reload();
    	//刷新调拨入-库区下拉框数据
    	grid.down('combobox[name=inAreaId]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商、退库原因下拉框数据
		var transferCauseCbx = form.down('combobox[name=transferCause]');
		var outAreaCbx = form.down('combobox[name=outAreaId]');
		var inAreaCbx = form.down('combobox[name=inAreaId]');
		var transferCauseStore = transferCauseCbx.getStore();
		var outAreaStore = outAreaCbx.getStore();
		var inAreaStore = inAreaCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的调拨原因、调拨出-库区号、调拨入-库区号
			//修改调拨原因store参数
			transferCauseStore.proxy.extraParams = {
				dictType: 6,
        		status: 1
			};
			//修改调拨出-库区号store参数
			outAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : 1
			};
			//修改调拨入-库区号store参数
			inAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : 1
			};
		}else{
			//修改调拨原因store参数
			transferCauseStore.proxy.extraParams = {
				dictType: 6,
        		status: -1
			};
			//修改调拨出-库区号store参数
			outAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : -1
			};
			//修改调拨入-库区号store参数
			inAreaStore.proxy.extraParams = {
				areaNature: -1,
        	 	status : -1
			};
		}
		//重加载库区下拉框数据
		transferCauseStore.load();
		outAreaStore.load();
		inAreaStore.load();
		
		//显示禁用项改变时，供应商改为全部
		if(showForbidden != null){
			transferCauseCbx.setValue(-1);
			outAreaCbx.setValue(-1);
			inAreaCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchTransferstockDemandBillItem(combobox);
	},
    /**
	 * combobox改变事件
	 */
 	onComboboxChange : function (combobox,showLableName,url){
		var Id = combobox.getValue();
		var showLableName=combobox.up('form').down('combobox[name='+showLableName+']');
		if(Id!=-1){
			ACBEE.Ext.Util.ajaxRequest(url,{Id : Id},function(result){
		  		if(null != showLableName){
		  			showLableName.setValue(result.map.areaNature);
		  		}
		  	});
		}
		else {
			showLableName.setValue('-1');
		}
	},
    /**
	 * 调出库区号改变事件
	 */
	onOutAreaCodeChange: function(combobox, record, value){
		this.onComboboxChange(combobox,"outAreaNature","warehouseArea/getAreaNature.action");
	},
	/**
	 * 调入库区号改变事件
	 */
	onInAreaCodeChange: function(combobox, record, value){
		this.onComboboxChange(combobox,"inAreaNature","warehouseArea/getAreaNature.action");
	},
	//显示调拨页面
	showTransfer:function(){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载库区编辑控制器
       ACBEE.Ext.Util.loadController(this.application, "transferstock.TransferstockBillEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('transferstockbilleditview');
		return win;
	},
	//清空按钮事件
	onClearTransferstockDemandBillItem:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var transferDemandBillItemGrid = button.up('grid');
		///清空查询条件
		transferDemandBillItemGrid.down('textfield[name=demandNo]').setValue('');
		transferDemandBillItemGrid.down('datefield[name=transferBillBeginDate]').setValue('');
		transferDemandBillItemGrid.down('datefield[name=transferBillEndDate]').setValue('');
		transferDemandBillItemGrid.down('datetimefield[name=planTransferBeginTime]').setValue('');
	    transferDemandBillItemGrid.down('datetimefield[name=planTransferEndTime]').setValue('');
		transferDemandBillItemGrid.down('combobox[name=status]').setValue('-1');
		transferDemandBillItemGrid.down('combobox[name=outAreaId]').setValue(-1);
		transferDemandBillItemGrid.down('combobox[name=outAreaNature]').setValue('-1');
		transferDemandBillItemGrid.down('combobox[name=inAreaId]').setValue(-1);
		transferDemandBillItemGrid.down('combobox[name=inAreaNature]').setValue('-1');
		transferDemandBillItemGrid.down('combobox[name=transferCause]').setValue(-1);
		transferDemandBillItemGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchTransferstockDemandBillItem(button);
	},
	//查询按钮事件处理
	onSearchTransferstockDemandBillItem:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var transferDemandBillItemGrid = button.up('grid');
		//取得表单对象
		var form = transferDemandBillItemGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得调拨需求号
		var demandNo = transferDemandBillItemGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(transferDemandBillItemGrid.down('datefield[name=transferBillBeginDate]').getValue()==null)
			var transferBillBeginDate=null;
	    else
		    transferBillBeginDate = Ext.Date.format(new Date(transferDemandBillItemGrid.down('datefield[name=transferBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(transferDemandBillItemGrid.down('datefield[name=transferBillEndDate]').getValue()==null)
			var transferBillEndDate=null;
	    else    
		    transferBillEndDate = Ext.Date.format(new Date(transferDemandBillItemGrid.down('datefield[name=transferBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划调拨开始
		if(transferDemandBillItemGrid.down('datetimefield[name=planTransferBeginTime]').getValue()==null)
	    	var planTransferBeginTime=null;
	    else
			planTransferBeginTime = Ext.Date.format(new Date(transferDemandBillItemGrid.down('datetimefield[name=planTransferBeginTime]').getValue()),'Y-m-d H:i:s');
		//取得计划调拨结束时间
	    if(transferDemandBillItemGrid.down('datetimefield[name=planTransferEndTime]').getValue()==null)
    		var planTransferEndTime=null;
    	else
			planTransferEndTime = Ext.Date.format(new Date(transferDemandBillItemGrid.down('datetimefield[name=planTransferEndTime]').getValue()),'Y-m-d H:i:s');
		//取得调拨原因
		var transferCause = transferDemandBillItemGrid.down('combobox[name=transferCause]').getValue();
		//取得调拨出-库区号
		var outAreaId = transferDemandBillItemGrid.down('combobox[name=outAreaId]').getValue();
		//取得调拨出-库区性质
		var outAreaNature = transferDemandBillItemGrid.down('combobox[name=outAreaNature]').getValue();
		//取得调拨状态
		var status = transferDemandBillItemGrid.down('combobox[name=status]').getValue();
		//取得调拨入-库区号
		var inAreaId = transferDemandBillItemGrid.down('combobox[name=inAreaId]').getValue();
		//取得调拨入-库区性质
		var inAreaNature = transferDemandBillItemGrid.down('combobox[name=inAreaNature]').getValue();
	    //取得显示禁用项
	    var showForbidden=transferDemandBillItemGrid.down('checkbox[name=showForbidden]').getValue();
	    
		//取得入库需求单的store
		var store = transferDemandBillItemGrid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			transferCause : transferCause,
			outAreaId : outAreaId,
			outAreaNature : outAreaNature,
			status : status,
			inAreaId : inAreaId,
			inAreaNature : inAreaNature,
			transferBillBeginDate : transferBillBeginDate,
			transferBillEndDate : transferBillEndDate,
			planTransferBeginTime : planTransferBeginTime,
			planTransferEndTime : planTransferEndTime,
			inAreaStatus: showForbidden ? -1 : 1,
			outAreaStatus: showForbidden ? -1 : 1,
			causeStatus: showForbidden ? -1 : 1,
			flag : 1
		};
		store.loadPage(1);
	},
	//调拨按钮事件
	onUpdatetransferDemandBillItem:function (grid,record){
		//加载调拨编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "transferstock.TransferstockBillEditCtl");
		//显示调拨window
		var win = ACBEE.Ext.Util.getWin('transferstockbilleditview');
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	//保存调拨需求单Id
	  	win.oldTransferstockDemandBillId=record.data.transferstockDemandBillId;
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('调拨操作 [' + record.get('demandNo') + ']');
		if(record.get('status') != 0 && record.get('actualTransferstockGroup') != null){
			ACBEE.Ext.Util.disableCompoment(null, win.down('form'), true);
		}
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(18== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-transfer')) {//点击了调拨
				this.onUpdatetransferDemandBillItem(grid,record);
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('transfer')) {
			this.onUpdatetransferDemandBillItem(grid, record);
		}
	}
});