/**
 * 需方商model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.model.baseinfo.DemanderViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['dictType','demanderId','demanderCode','demanderName','address','corporation','bank','account','tariff',
	'contacts1','tel1','contacts2','tel2','userId','userName','status','demanderNature','dictId','natureName',{
		name:'displayStatus',
		convert:function(value,record){
			var v=record.raw.status;
			if(null==v)
				return '<span class="red">未知</span>';
			else if(1==v)
				return '<span class="blue">启用</span>';
			else
				return '<span class="red">禁用</span>';
		},
		mapping:'displayStatus'
	},{
		name:'demanderBeginDate',
		type:'string',
		convert:function(value){
			var demanderBeginDate=Ext.Date.format(new Date(value),"Y-m-d");
			return demanderBeginDate;
		},
		mapping:'demanderBeginDate'
	},{
		name:'demanderEndDate',
	 	type:'string',
	 	convert:function(value){
	 		var demanderEndDate=Ext.Date.format(new Date(value),"Y-m-d");
	 		return demanderEndDate;
	 	},
	 	mapping:'demanderEndDate'
	}]
});

