/**
 * 员工视图model.
 * @author 奚志敏
 * @version 1.0.0, 2015-08-03
 */
Ext.define('WMS.model.baseinfo.StaffViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['staffId','jobNumber','staffName','deptId','deptName','rankId','rankName','groupId','groupName','tel',{
		name : 'entryTime',
		convert: function(value, record) {
            return null == value ? "" : Ext.Date.format(new Date(value), 'Y-m-d');
        },
		mapping : 'entryTime'
	},
	'workContent','leader', {
  		name:'displayStatus',
  		convert:function(value, record){
  			var v = record.raw.status;
  			if(null == v)
  				return '<span class="red">未知</span>';
  			else if(1 == v)
  				return '<span class="blue">启用</span>';
  			else 
  				return '<span class="red">禁用</span>';
  		},
  		mapping:'displayStatus'
  	},'status','userId','userName','lastLoginIP',{
		name : 'lastLoginTime',
		convert: function(value, record) {
            return null == value ? "" : Ext.Date.format(new Date(value), 'Y-m-d H:i:s');
        },
		mapping : 'lastLoginTime'
	}]
});