/**
 * 供应商视图model.
 * @author 高元称
 * @version 1.0.0, 2015-07-27
 */
Ext.define('WMS.model.baseinfo.SupplierViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['dictType','supplierId','supplierCode','supplierName','address','corporation','bank',
	'account','tariff','contacts1','tel1','contacts2','tel2','supplierNature',
	'userId','status','userId','userName','natureName','dictId',{
  		name:'displayStatus',
  		convert:function(value, record){
  			var v = record.raw.status;
  			if(null == v)
  				return '<span class="red">未知</span>';
  			else if(1 == v)
  				return '<span class="blue">启用</span>';
  			else 
  				return '<span class="red">禁用</span>';
  		},
  		mapping:'displayStatus'
  	},{
  		name: 'supplyBeginDate',
  		type: 'string',
  		convert:function(value){  
            var supplyBeginDate = Ext.Date.format(new Date(value),"Y-m-d");
            return supplyBeginDate;  
         },
         mapping:'supplyBeginDate'
  	},{
  		name: 'supplyEndDate',
  		type: 'string',
  		convert:function(value){  
            var supplyEndDate = Ext.Date.format(new Date(value),"Y-m-d");
            return supplyEndDate;  
         },
         mapping:'supplyEndDate'
  	}]
});