/**
 * 退库需求单model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-17
 */
Ext.define('WMS.model.cancelstock.CancelStockDemandBillMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['cancelstockDemandBillId','demandNo','appointmentDate','planCancelTime','supplierId','orderNo','itemNo','cancelCause','areaId','cancelCauseName','pickupCompany','vehicleNo',
	'pickupPerson','supplierName','actualCancelTime','totalQuantity','totalPrice','areaName','actualCancelstockGroup','status',{
	name:'displayStatus',
		convert:function(value,record){
			var v=record.raw.status;
			if(null==v)
				return '<span class="red">未知</span>';
			else if(1==v)
				return '<span class="blue">退库中</span>';
			else if(2==v)
				return '<span class="blue">已退库</span>';
			else
				return '<span class="red">未退库</span>';
		},
		mapping:'displayStatus'
	},{
		name:'appointmentDate',
		type:'string',
		convert:function(value){
			var appointmentDate=Ext.Date.format(new Date(value),"Y-m-d");
			return appointmentDate;
		},
		mapping:'appointmentDate'
	},{
		name:'planCancelTime',
		type:'string',
		convert:function(value){
			var planCancelTime=Ext.Date.format(new Date(value),"Y-m-d H:i:s");
			return planCancelTime;
		},
		mapping:'planCancelTime'
	},{
		name:'actualCancelTime',
		type:'string',
		convert:function(value){
			if(value !=null){
				var actualCancelTime=Ext.Date.format(new Date(value),"Y-m-d H:i:s");
				return actualCancelTime;
			}
		},
		mapping:'actualCancelTime'
	}]
});
