/**
 * 入库任务分配、入库上架操作视图model.
 * @author 高元称
 * @version 1.0.0, 2015-08-19
 */
Ext.define('WMS.model.instock.InstockBillViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['instockBillId','demandNo','appointmentDate','planArrivalTime','actualArrivalTime', 'supplierName','orderNo',
	'itemNo','deliveryCompany','vehicleNo','deliveryman','instockGroupName','actualInstockGroupName','groundingGroupName','groundingGroup',{
		name : 'appointmentDate',
		type : 'string',
		convert : function(value){
			var appointmentDate = Ext.Date.format(new Date(value), "Y-m-d");
			return appointmentDate;
		},
		mapping : 'appointmentDate'
		
	},{
		name : 'planArrivalTime',
		type : 'string',
		convert : function(value){
			var planArrivalTime = Ext.Date.format(new Date(value), "Y-m-d H:i:s");
			return planArrivalTime;
		},
		mapping : 'planArrivalTime'
	
	},{
		name : 'actualArrivalTime',
		type : 'string',
		convert : function(value){
			var actualArrivalTime = Ext.Date.format(new Date(value), "Y-m-d H:i:s");
			return actualArrivalTime;
		},
		mapping : 'actualArrivalTime'
	},{
		name:'displayStatus',
  		convert:function(value, record){
  			var v = record.raw.status;
  			if(null == v)
  				return '<span class="red">未知</span>';
  			else if(1 == v)
  				return '<span class="blue">入库中</span>';
  			else if(0 == v)
  				return '<span class="black">未入库</span>';
  			else 
  				return '<span class="red">已入库</span>';
  		},
  		mapping:'displayStatus'
	}]
});