/**
 * 入库预约model.
 * @author 高元称
 * @version 1.0.0, 2015-08-11
 */
Ext.define('WMS.model.instock.InstockDemandBillViewMdl', { 
	extend : 'Ext.data.Model', 
	fields : ['instockDemandBillId','demandNo',
	'supplierId','orderNo','itemNo','deliveryCompany','vehicleNo','deliveryman','instockGroup',
	'actualInstockGroup','supplierName','instockNature','instockGroupName','flag','actualInstockGroupName',
	'actualArrivalTime','totalQuantity','totalPrice',{
		name : 'displayStatus',
		convert : function(value, record){
			var v = record.raw.status;
			if(null == v)
				return '<span class="red">未知</span>';
			else if(1 == v)
				return '<span class="blue">已核实</span>';
			else
				return '<span class="red">未核实</span>';
		},
		mapping : 'displayStatus'
		
	},'status',{
  		name: 'appointmentDate',
  		type: 'string',
  		convert:function(value){  
            var supplyBeginDate = Ext.Date.format(new Date(value),"Y-m-d");
            return supplyBeginDate;  
         },
         mapping:'appointmentDate'
  	},{
  		name: 'planArrivalTime',
  		type: 'string',
  		convert:function(value){  
            var supplyBeginDate = Ext.Date.format(new Date(value),"Y-m-d H:i:s");
            return supplyBeginDate;  
         },
         mapping:'planArrivalTime'
  	},{
  		name: 'actualArrivalTime',
  		type: 'string',
  		convert:function(value){
  			return null == value || "" == value ? "" : Ext.Date.format(new Date(value),"Y-m-d H:i:s");
         },
         mapping:'actualArrivalTime'
  	}]
});