/**
 * 出库明细model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.model.outstock.OutstockBillGridMdl', {
	extend: 'Ext.data.Model', 
	fields:  ['goodsId','goodsName','goodsCode','productBatch','actualOutstockQuantity','instockTime',	
	      	'trayNumber','planOutstockLocation','locationNo','outstockTacticsWay','outstockTactics','planAreaId','areaId',
	    	'outstockTacticsName','price','totalPrice','supplierName','status','supplierId','planAreaName','areaName',
	    	'offshelvesTime','planLocationNo','actualOutstockLocation','actualArrivalQuantity','stockQuantity',{
		name: 'instockTime',
  		convert:function(value){
  			var instockTime = "";
  			if (value.toString().length == 13){
  				instockTime = Ext.Date.format(new Date(value),"Y-m-d");
  			} else {
  				instockTime = value; 
  			}
            return instockTime;  
         },
         mapping:'instockTime'
	},{
		name:'displayStatus',
		convert:function(value,record){
			var v=record.raw.status;
			if(null==v)
				return '<span class="red">未知</span>';
			else if(1==v)
				return '<span class="blue">已下架</span>';
			else
				return '<span class="red">未下架</span>';
		},
		mapping:'displayStatus'
	},{
		name:'outstockTacticsName',
		convert:function(value,record){
			var v=record.raw.outstockTactics;
			if(null==v)
				return '<span class="red">未知</span>';
			else if(1==v)
				return '<span>先进先出</span>';
			else if(2==v)
				return '<span>后进先出</span>';
			else
				return '<span>人工选择</span>';
		},
		mapping:'outstockTacticsName'
		
	}]
});