/**
 * 出库单model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.model.outstock.OutstockBillViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['outstockBillId','demandNo','appointmentDate','planArrivalTime',
	'orderNo',	'itemNo','pickupCompany','vehicleNo','pickupPerson'	,'outstockNatureName',
	'outstockGroupName','actualOutstockGroup','demanderName','status',{
		name:'displayStatus',
		convert:function(value,record){
			var v=record.raw.status;
			if(null==v)
				return '<span class="red">未知</span>';
			else if(1==v)
				return '<span class="blue">出库中</span>';
			else
				return '<span class="red">未出库</span>';
		},
		mapping:'displayStatus'
	},{
		name:'appointmentDate',
		type:'string',
		convert:function(value){
			var appointmentDate=Ext.Date.format(new Date(value),"Y-m-d");
			return appointmentDate;
		},
		mapping:'appointmentDate'
	},{
		name:'planArrivalTime',
		type:'string',
		convert:function(value){
			var planArrivalTime=Ext.Date.format(new Date(value),"Y-m-d H:i:s");
			return planArrivalTime;
		},
		mapping:'planArrivalTime'
	}]
});