/**
 * 出库需求明细model.
 * @author 高元称
 * @version 1.0.0, 2015-09-02
 */
Ext.define('WMS.model.outstock.OutstockDemandBillGridMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['goodsCode','goodsName','goodsId', 'productBatch','totalPrice',
	'planArrivalQuantity','price','supplierId','supplierName','actualArrivalQuantity',
	'outstockTactics','planOutstockLocation','locationNo','instockTime','actualOutstockTotalQuantity',{
		name: 'instockTime',
  		type: 'string',
  		convert:function(value){ 
  			if(null==value){
  				return null;
  			}
            var instockTime = Ext.Date.format(new Date(value),"Y-m-d");
            return instockTime;  
         },
         mapping:'instockTime'
	}]
});