/**
 * 出库单视图model.(出库分配)
 * @author 高元称
 * @version 1.0.0, 2015-09-02
 */
Ext.define('WMS.model.outstock.OutstockDemanderBillViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['demanderName','appointmentDate','demandNo','planArrivalTime','itemNo',
		'orderNo','pickupCompany','pickupPerson','vehicleNo','outstockNatureName','status',
		'demanderId','outstockNature','totalQuantity','totalPrice','outstockDemandBillId',
		'outstockGroup','outstockGroupName','demanderCode',{
		name:'displayStatus',
		convert:function(value,record){
			var v=record.raw.status;
			if(null==v)
				return '<span class="red">未知</span>';
			else if(1==v)
				return '<span class="blue">已分配</span>';
			else
				return '<span class="red">未分配</span>';
		},
		mapping:'displayStatus'
	},{
		name:'appointmentDate',
		type:'string',
		convert:function(value){
			var appointmentDate=Ext.Date.format(new Date(value),"Y-m-d");
			return appointmentDate;
		},
		mapping:'appointmentDate'
	},{
		name:'planArrivalTime',
		type:'string',
		convert:function(value){
			var planArrivalTime=Ext.Date.format(new Date(value),"Y-m-d H:i:s");
			return planArrivalTime;
		},
		mapping:'planArrivalTime'
	}]
});