/**
 * 库存视图model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.model.report.StockReportViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['goodsCode','goodsName','supplierName','areaName','locationNo','totalPrice','volume','quantity','price',
	          'outerPackingQuantity','weight','outerPackingVolume','outerPackingWeight','innerPackingQuantity',
	          'innerPackingVolume','innerPackingWeight','natureName','instockTime','stockId',{
  		name: 'instockTime',
  		type: 'string',
  		convert:function(value){
  			var instockTime = "";
  			if (value != null && value != ""){
  				instockTime = Ext.Date.format(new Date(value),"Y-m-d H:i:s");
  			}
            return instockTime;
         },
         mapping:'instockTime'
  	}]
});
