/**
 * 操作流水model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-08-05
 */
Ext.define('WMS.model.stock.OperFlowViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['operFlowId','supplierId','supplierName','demanderId','demanderName','demandNo','goodsId',
	          'goodsCode','goodsName','productBatch','quantity','operTime','deliveryman','locationId','locationNo',
	          'locationId2','locationNo2','causeStatus',{
					name:'displayLocationNo',
					convert:function(value, record){
						var x = record.raw.operType;
						if(6 == x)
							return record.raw.locationNo+'->'+record.raw.locationNo2;
						else
							return record.raw.locationNo;
					},
					mapping:'displayLocationNo'
				},'areaId','areaName','areaId2','areaName2',{
					name:'displayarea',
					convert:function(value, record){
						var x = record.raw.operType;
						if(6 == x)
							return record.raw.areaName+'->'+record.raw.areaName2;
						else
							return record.raw.areaName;
					},
					mapping:'displayarea'
				},'areaNature','userId','vehicleNo','deliveryCompany','staffName',{
	  				name:'displayAreaNature',
	  				convert:function(value, record){
	  					var w = record.raw.areaNature;
	  					if(null == w)
	  						return '<span class="red">未知</span>';
						else if(1 == w)
							return '<span class="blue">可用</span>';
						else
							return '<span class="red">不可用</span>';
					},
					mapping:'displayAreaNature'
	  			},'areaNature','location',{
	  				name:'displayOperType',
	  				convert:function(value, record){
	  					var v = record.raw.operType;
	  					if(null == v)
	  						return '<span>未知</span>';
	  					else if(6 == v)
	  						return '<span>调拨</span>';
	  					else if(5 == v)
	  						return '<span>退库</span>';
	  					else if(4 == v)
	  						return '<span>出库</span>';
	  					else if(3 == v)
	  						return '<span>入库</span>';
	  				},
	  				mapping:'displayOperType'
	  			},'operType','causeName','causeId',{
	  				name: 'operTime',
	  				type: 'string',
	  				convert:function(value){  
	  					var supplyBeginDate = Ext.Date.format(new Date(value),"Y-m-d H:i:s");
	  					return supplyBeginDate;  
	  				},
	  				mapping:'operTime'
	  			}
	]
});