/**
 * 库存视图model.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.model.stock.StockViewMdl', { 
	extend: 'Ext.data.Model', 
	fields:  ['stockId','supplierId','goodsId','productBatch','quantity','locationId','instockTime',
	          'supplierName','locationNo','goodsName','goodsCode','areaName','areaId','areaNature','orderNo',
	          'locationStatus','areaStatus','supplierStatus',{
  		name: 'instockTime',
  		type: 'string',
  		convert:function(value){
  			var instockTime = "";
  			if (value != null && value != ""){
  				instockTime = Ext.Date.format(new Date(value),"Y-m-d H:i:s");
  			}
            return instockTime;
         },
         mapping:'instockTime'
  	}]
});
