/**
 * 调拨视图model.
 * @author 高元称
 * @version 1.0.0, 2015-08-24
 */
Ext.define('WMS.model.transferstock.TransferstockDemandBillViewMdl', { 
	extend : 'Ext.data.Model', 
	fields : ['appointmentDate','demandNo','transferstockDemandBillId','planTransferTime',
	'pickupCompany','pickupPerson','vehicleNo','inAreaCode','inAreaNature','outAreaCode',
	'outAreaNature','inLocationNo','outLocationNo','outLocationNature','inLocationNature',
	'transferCauseName',"status","transferCause","inAreaId","outAreaId","inLocationId",
	"outLocationId",'actualTransferstockGroup','totalQuantity','totalPrice','actualTransferTime','warehouseareaoutName','warehouseareaName',{
		name : 'inAreaNature',
		convert : function(value, record){
			var v = record.raw.inAreaNature;
			if(null == v)
				return '<span class="red">未知</span>';
			else if(1 == v)
				return '<span class="blue">可用</span>';
			else
				return '<span class="red">不可用</span>';
		},
		mapping : 'inAreaNature'
	},{
		name : 'outAreaNature',
		convert : function(value, record){
			var v = record.raw.outAreaNature;
			if(null == v)
				return '<span class="red">未知</span>';
			else if(1 == v)
				return '<span class="blue">可用</span>';
			else
				return '<span class="red">不可用</span>';
		},
		mapping : 'outAreaNature'
		
	},{
  		name: 'appointmentDate',
  		type: 'string',
  		convert:function(value){  
            var supplyBeginDate = Ext.Date.format(new Date(value),"Y-m-d");
            return supplyBeginDate;  
         },
         mapping:'appointmentDate'
  	},{
  		name: 'planTransferTime',
  		type: 'string',
  		convert:function(value){  
            var supplyBeginDate = Ext.Date.format(new Date(value),"Y-m-d H:i:s");
            return supplyBeginDate;  
        },
         mapping:'planTransferTime'
  	},{
		name : 'displayStatus',
		convert : function(value, record){
			var v = record.raw.status;
			if(null == v)
				return '<span class="red">未知</span>';
			else if(1 == v)
				return '<span class="blue">调拨中</span>';
			else if(0 == v)
				return '<span class="red">未调拨</span>';
			else
				return '<span class="blue">已调拨</span>';
		},
		mapping : 'displayStatus'
  	}]
});