/**
 * 需方商store.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.store.baseinfo.DemanderViewStr',{
    extend: 'Ext.data.Store',
    requires: 'WMS.model.baseinfo.DemanderViewMdl',
 	model: 'WMS.model.baseinfo.DemanderViewMdl',
 	autoLoad: true,
	//自定义配置项，是否有空选项
 	hasEmptyItem: false,
 	proxy: {
        type: 'ajax',
        actionMethods:'POST',
        url:'demander/searchDemanderPage.action',
        reader: {
            type: 'json',
            root: 'rows'
        }
    },
    constructor: function (config) {
    	if(undefined != config && null != config) {
	 		//将配置中的参数传递给proxy
	        this.proxy.url = config.url;
	        this.proxy.extraParams = config.params;
	        this.hasEmptyItem = config.hasEmptyItem;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	if(this.hasEmptyItem) {
	        	//添加空选项
        		ACBEE.Ext.Util.createComboBoxEmptyItem(store, 
	        		'WMS.model.baseinfo.DemanderViewMdl', {"demanderId": -1, "demanderName": "全部"});
        	}
        }
    }
});
