/**
 * 货物store.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.store.baseinfo.GoodsStr',{
    extend: 'Ext.data.Store',
    requires: 'WMS.model.baseinfo.GoodsMdl',
 	model: 'WMS.model.baseinfo.GoodsMdl',
 	autoLoad: true,
 	proxy: {
        type: 'ajax',
        actionMethods: 'POST',
        url: 'goods/searchGoodsPage.action',
        reader: {
            type: 'json',
            root: 'rows'
        }
    },
    constructor: function (config) {
    	if(undefined != config && null != config) {
	 		//将配置中的参数传递给proxy
	        this.proxy.url = config.url;
	        this.proxy.extraParams = config.params;
	        this.hasEmptyItem = config.hasEmptyItem;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	if(this.hasEmptyItem) {
	        	//添加空选项
        		ACBEE.Ext.Util.createComboBoxEmptyItem(store, 
	        		'WMS.model.baseinfo.GoodsMdl', {"goodsId": -1, "goodsCode": "全部", "goodsName": "全部"});
        	}
        }
    } 
});
