/**
 * 员工视图store.
 * @author 奚志敏
 * @version 1.0.0, 2015-08-03
 */
Ext.define('WMS.store.baseinfo.StaffViewStr',{
    extend: 'Ext.data.Store',
    requires: 'WMS.model.baseinfo.StaffViewMdl',
 	model: 'WMS.model.baseinfo.StaffViewMdl',
 	autoLoad: true,
 	//自定义配置项，是否有空选项
 	hasEmptyItem: false,
 	proxy: {
        type: 'ajax',
        actionMethods: 'POST',
        reader: {
            type: 'json',
            root: 'rows'
        }
    },
    constructor: function (config) {
    	if(undefined != config && null != config) {
	 		//将配置中的参数传递给proxy
	        this.proxy.url = config.url;
	        this.proxy.extraParams = config.params;
	        this.hasEmptyItem = config.hasEmptyItem;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	if(this.hasEmptyItem) {
	        	//添加空选项
        		ACBEE.Ext.Util.createComboBoxEmptyItem(store, 
	        		'WMS.model.baseinfo.StaffViewMdl', {"staffId": -1, "staffName": "全部"});
        	}
        }
    }
});
