/**
 * 库区性质store.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-23
 */
Ext.define('WMS.store.common.AreaNatureStr',{
    extend: 'Ext.data.Store',
    fields: ['value', 'name'],
    //自定义配置项，是否有空选项
 	hasEmptyItem: true,
    data : [
        {"value":1, "name":"可用"},
        {"value":0, "name":"不可用"}
    ],
    constructor: function (config) {
    	if(undefined != config && null != config) {
	        this.hasEmptyItem = config.hasEmptyItem;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	//增加空选项
        	if(this.hasEmptyItem) {
        		store.insert(0, {value:"-1", name:"全部"});  
        	}
        }
    }
});
