/**
 * 取出库位性质名称store.
 * @author 高元称
 * @version 1.0.0, 2015-08-3
 */
Ext.define('WMS.store.common.LocationNatureNameStr',{
    extend: 'Ext.data.Store',
    requires: 'WMS.model.common.LocationNatureMdl',
 	model: 'WMS.model.common.LocationNatureMdl',
 	//自定义配置项，是否有空选项
 	hasEmptyItem: false,
 		proxy: {
        type: 'ajax',
        actionMethods: 'POST',
        reader: {
        	type: 'json'
        }
    },
    constructor: function (config) {
    	if(undefined != config && null != config) {
	 		//将配置中的参数传递给proxy
	        this.proxy.url = config.url;
	        this.proxy.extraParams = config.params;
	        this.hasEmptyItem = config.hasEmptyItem;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	if(this.hasEmptyItem) {
	        	//添加空选项
        		ACBEE.Ext.Util.createComboBoxEmptyItem(store, 
	        		'WMS.model.common.LocationNatureMdl', {"natureId": -1, "natureName": "全部"});
        	}
        }
    }
});
