/**
 * 模块store.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.store.menufunction.ModuleStr',{
    extend: 'Ext.data.Store',
    requires: 'WMS.model.menufunction.ModuleMdl',
 	model: 'WMS.model.menufunction.ModuleMdl',
 	autoLoad: true,
 	proxy: {
        type: 'ajax',
        reader: {
            type: 'json',
            successProperty: 'success'
        }
    },
    constructor: function (config) {
    	if(undefined != config && null != config) {
	 		//将配置中的参数传递给proxy
	        this.proxy.url = config.url;
	        this.proxy.extraParams = config.params;
	        this.hasEmptyItem = config.hasEmptyItem;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	if(this.hasEmptyItem) {
	        	//添加空选项
        		ACBEE.Ext.Util.createComboBoxEmptyItem(store, 
	        		'WMS.model.menufunction.ModuleMdl', {"moduleId": -1, "moduleName": "全部"});
        	}
        }
    }
});
