/**
 * 库存store.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.store.stock.StockViewStr',{
    extend: 'Ext.data.Store',
    requires: 'WMS.model.stock.StockViewMdl',
 	model: 'WMS.model.stock.StockViewMdl',
 	autoLoad: true,
 	proxy: {
        type: 'ajax',
        actionMethods: 'POST',
        reader: {
            type: 'json',
            root: 'rows'
        }
    },
    constructor: function (config) {
    	if(undefined != config && null != config) {
	 		//将配置中的参数传递给proxy
	        this.proxy.url = config.url;
	        this.proxy.extraParams = config.params;
    	}
        this.callParent();
    },
    listeners: {  
        load : function(store, records, options ){
        	if(this.hasEmptyItem) {
	        	//添加空选项
        		ACBEE.Ext.Util.createComboBoxEmptyItem(store, 
	        		'WMS.model.common.DictMdl', {"stockId": -1, "instockTime": "全部","locationNo": "全部"});
        	}
        }
    }
});
