/**
 * 需求方信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.view.baseinfo.DemanderSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.demandersearchview',
	id: 'demandersearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires : [
		'WMS.store.baseinfo.DemanderViewStr',
	    'WMS.store.common.DictStr'
	],
	stores:[
		'WMS.store.baseinfo.DemanderViewStr'
	],
	models:[
		'WMS.model.baseinfo.DemanderViewMdl'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'需方商编码',
					name:'demanderCode',
					labelWidth:90,
					width:250,
					length:16,
		        	vtypeText:'需方商编码最多可输入16个字符<br>需方商编码只能输入英文、数字和字符',
	        		vtype: 'exceptChinese'
				},{
				    xtype:'textfield',
					fieldLabel:'需方商名称',
					name:'demanderName',
					labelWidth:90,
					width:250,
					length:100,
	        		vtypeText : '需方商名称最多可输入100个字符',
        		    vtype: 'limitLen'
				},{
					xtype:'combobox',
					fieldLabel:'需方商性质',
					name:'demanderNature',
					labelWidth:80,
					width:250,
					listConfig: {
						getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField,10);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
					value:-1,
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 2,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'dict/getDictList.action'        	
		            })
				},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'联系人',
					name:'contacts1',
					labelWidth:90,
					width:250,
					length:20,
	        		vtypeText:'联系人最多可输入20个字符<br>联系人只能输入中文和英文',
	        		vtype: 'chnEng'
		   		},{
			        xtype:'textfield',
					fieldLabel:'联系电话',
					name:'tel1',
					labelWidth:90,
					width:250,
					length:50,
	        		vtypeText:'电话最多可输入50个字符<br>电话号码只能输入数字和符号',
	        		vtype: 'phone'
		   		},{
				    xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    labelWidth :80,
				    width : 250,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				}]
		   	},{
		   		xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
			        xtype:'datefield',
					fieldLabel:'需方开始日期',
					name:'demanderBeginDate',
					labelWidth:90,
					width:250,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'需方开始日期必须早于或等于需方停止日期',
	        		vtype: 'date'
		  		},{
			        xtype:'datefield',
					fieldLabel:'需方停止日期',
					name:'demanderEndDate',
					labelWidth:90,
					width:250,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'需方开始日期必须晚于或等于需方开始日期',
	        		vtype: 'date',
	        		compareTo:'demanderBeginDate'
		    	},{
		    		border:false,
		    		width:15
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
	   			}]		
		   	}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			}, {
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			}, {
				xtype : 'button',
				text : '导入',
				name : 'btn-import',
				iconCls: 'btn-import'
			}, {
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			}, {
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls: 'btn-openStatus'
			}, {
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '需方商编码', dataIndex: 'demanderCode', width:150,style :"text-align:center",align:'left'},
		    { text: '需方商名称', dataIndex: 'demanderName', width:200,style :"text-align:center",align:'left'},
		    { text: '需方商性质', dataIndex: 'natureName', width:110, style :"text-align:center", align:'left'},
		    { text: '地址', dataIndex: 'address', hidden: true},
		    { text: '法人代表', dataIndex: 'corporation', style :"text-align:center", width:170,  align:'left'},
		    { text: '开户行', dataIndex: 'bank', hidden: true},
		    { text: '账号', dataIndex: 'account', hidden: true},
		    { text: '税号', dataIndex: 'tariff', hidden: true},
		    { text: '联系人1', dataIndex: 'contacts1', hidden: true},
		    { text: '联系电话1', dataIndex: 'tel1', hidden: true},
		    { text: '联系人2', dataIndex: 'contacts2', hidden: true},
		    { text: '联系电话2', dataIndex: 'tel2', hidden: true},
		    { text: '需方开始日期', dataIndex: 'demanderBeginDate', width:130, style :"text-align:center", align:'center'},
		    { text: '需方停止日期', dataIndex: 'demanderEndDate', width:130, style :"text-align:center", align:'center'},
		    { text: '状态', dataIndex: 'displayStatus', width:80, style :"text-align:center",  align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的需方商信息！',
			store:Ext.create('WMS.store.baseinfo.DemanderViewStr', {
				url:'demander/searchDemanderPage.action'
			}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});
