/**
 * 货物信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2016-07-09
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.baseinfo.GoodsEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.goodseditview',
	id : 'goodseditview',
	title : '货物信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 720,
	height : 470,
	layout : 'fit',
	modal : true,
	requires:[
		'Ext.ux.TreeCombox',
        'WMS.store.common.StatusStr',
        'WMS.store.baseinfo.GoodsStr'
	],
	stores:[
        'WMS.store.baseinfo.GoodsStr'
	],
	models:[
        'WMS.model.baseinfo.GoodsMdl'
	],
	/**
	 * 创建货物类别树
	 * @return {}
	 */
	createGCStore: function() {
		var store = Ext.create('WMS.store.systemservice.dictionary.GoodsPullDownStr');
		store.proxy.extraParams = {
			status : 1
		};
		return store;
	},
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 10,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 100,
			        	margin: '6'
			    	},
		    		items: [{
		        		xtype: 'textfield',
		        		width: 270,
		        		labelWidth : 100,
		        		name: 'goodsCode',
		        		allowBlank : false,
		        		regex: /^\S+$/,//空格为非法字符
		        		fieldLabel: '货物编号',
		        		length:50,
		        		vtypeText:'货物编号最多可输入50个字符',
		        		vtype: 'limitLen'
		       		 },{
			        		xtype: 'textfield',
			        		width: 270,
			        		labelWidth : 100,
			        		name: 'goodsName',
			        		allowBlank : false,
			        		fieldLabel: '品名',
			        		margin: '10 0 0 60',
			        		length:50,
			        		vtypeText:'品名最多可输入50个字符',
			        		vtype: 'limitLen',
			        		listeners:{  
		        				   'blur':function(e){e.setValue(e.getValue().trim())}  
				        				} 
						}]
		     },{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},
	    		items:[{
	    			xtype: 'treecombox',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'gcId',
	        		fieldLabel: '货物类别',
	        		displayField: 'text',
					minPickerHeight: 200,
					editable: false,
	        		allowBlank : false,
	        		rootVisible: false,
	        		emptyText: "--请选择--",
	        		store: this.createGCStore()
	    		},{
	    			xtype:'combo',
				    fieldLabel:'供应商',
				    margin: '10 0 0 60',
				    allowBlank:false,
				    name:'supplierId',
				    labelWidth : 100,
	        		width : 270,
	        		emptyText: "--选择或输入--",
	        		editable: true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		displayField: 'supplierName',
		            valueField: 'supplierId',
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: 1
		            	},
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
    		    }]
		    },{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},
	    		items:[{
			    	xtype: 'textfield',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'specs',
	        		allowBlank : false,
	        		fieldLabel: '规格',
	        		length:50,
	        		vtypeText:'规格最多可输入50个字符',
	        		vtype: 'limitLen',
	        		listeners:{  //不允许只输入空格  彭婷婷
     				   'blur':function(e){e.setValue(e.getValue().trim())}  
		        				} 
   				},{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'price',
	        		allowBlank : false,
	        		fieldLabel: '价格',
	        		margin: '10 0 0 60',
	        		length:10,
	        		decimalDigits:3,
	        		vtypeText:'价格最多可输入10个字符<br>价格只能输入小数点后三位',
	        		vtype: 'currency'
    			},{ xtype:"displayfield",value:"元" }]
		    },{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},	    		
	    		items:[{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'material',
	        		fieldLabel: '材质',
	        		length:20,
	        		vtypeText:'材质最多可输入20个字符',
	        		vtype: 'limitLen'
	    		},{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'weight',
	        		fieldLabel: '重量',
	        		margin: '10 0 0 60',
	        		length:10,                              	        		
	        		decimalDigits:2,
	        		vtypeText:'重量最多可输入10个字符<br>重量只能输入小数点后两位',
	        		vtype: 'currency'
	    		},{ xtype:"displayfield",value:"千克" }
	    		]
			},{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},
	    		items:[{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth :100,
	        		name: 'maxStock',
	        		fieldLabel: '最大库存量',
	        		length:10,
	        		vtypeText:'最大库存量最多可输入10个字符<br>最大库存量只能输入正整数',
	        		vtype: 'number'
	    		},{ xtype:"displayfield",value:"个" },
	    		{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'minStock',
	        		fieldLabel: '最小库存量',
	        		margin: '10 0 0 35',
	        		length:10,
	        		vtypeText:'最小库存量最多可输入10个字符<br>最小库存量只能输入正整数',
	        		vtype: 'number'
    			},{ xtype:"displayfield",value:"个" }]
			},{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},
	    		items:[{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth :100,
	        		name: 'outerPackingVolume',
	        		fieldLabel: '外包装货物体积',
        			length:10,
	        		vtypeText:'外包装货物体积最多可输入10个字符<br>外包装货物体积只能输入正整数',
	        		vtype: 'number'
				},{ xtype:"displayfield",value:"立方米" },{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth : 100,
	        		name: 'outerPackingWeight',
	        		fieldLabel: '外包装货物重量',
	        		margin: '10 0 0 10',
	        		length:10,
	        		vtypeText:'外包装货物重量最多可输入10个字符<br>外包装货物重量只能输入正整数',
	        		vtype: 'number'
    		    },{ xtype:"displayfield",value:"千克" }]
			},{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},
	    		items:[{
	    		  	xtype: 'textfield',
	        		width: 270,
	        		labelWidth :100,
	        		name: 'innerPackingVolume',
	        		fieldLabel: '内包装货物体积',
	        		length:10,
	        		vtypeText:'内包装货物体积最多可输入10个字符<br>内包装货物体积只能输入正整数',
	        		vtype: 'number'
	    		},{ xtype:"displayfield",value:"立方米" },{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth :100,
	        		name: 'innerPackingWeight',
	        		fieldLabel: '内包装货物重量',
	        		margin: '10 0 0 10',
	        		length:10,
	        		vtypeText:'内包装货物重量最多可输入10个字符<br>内包装货物重量只能输入正整数',
	        		vtype: 'number'
	        		
				},{ xtype:"displayfield",value:"千克" }]
			},{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 100,
		        	margin: '6'
	    		},
				items:[{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth :100,
	        		name: 'outerPackingQuantity',
	        		fieldLabel: '外包装数量',
	        		length:10,
	        		vtypeText:'外包装数量最多可输入10个字符<br>外包装数量只能输入正整数',
	        		vtype: 'number'
			},{ xtype:"displayfield",value:"个" },{
	    			xtype: 'textfield',
	        		width: 270,
	        		labelWidth :100,
	        		name: 'innerPackingQuantity',
	        		fieldLabel: '内包装数量',
	        		margin: '10 0 0 35',
	        		length:10,
	        		vtypeText:'内包装数量最多可输入10个字符<br>内包装数量只能输入正整数',
	        		vtype: 'number'
			},{ xtype:"displayfield",value:"个" }]
		},{
			xtype : 'panel',
	        layout:'column',
		    border: false,
	        defaults : {
    			labelAlign : 'right',
    			labelWidth : 100,
	        	margin: '6'
	    	},
    		items: [{
				xtype: 'textfield',
	    		width: 270,
	    		labelWidth :100,
	    		name: 'shelfLife',
	    		fieldLabel: '保质期',
	    		length:10,
        		vtypeText:'保质期最多可输入10个字符<br>保质期只能输入正整数',
        		vtype: 'number'
			},{ xtype:"displayfield",value:"天" },]
     },{
			xtype:'panel',
			layout:'column',
	    	border: false,
        	defaults : {
    			labelAlign : 'right',
    			xtype: 'radiofield',
    			labelWidth : 100,
    			margin: '6'
    		},
    		items:[{
		        xtype: 'displayfield',
		        fieldLabel: '状态',
		        style: 'text-align: right;'
		    },{
				boxLabel : '启用',
        		name : 'status',
        		inputValue: '1',
        		checked:"checked"
			},{
		        boxLabel : '禁用',
        		name : 'status',
        		inputValue: '0'
			}]
		}]
	}]
}],
		this.fbar = [{
	    		xtype: 'button',
	        	margin: '6',
	        	text: '保存',
	        	name: 'btn-save',
				iconCls: 'btn-save'
	    	},{
	    		xtype: 'button',
	        	margin: '6',
	        	text: '取消',
	        	name: 'btn-cancel',
				iconCls: 'btn-cancel',
	        	scope: this,
	        	handler: this.close
	    	}];
		this.callParent(arguments);
	}
});