/**
 * 货物信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.baseinfo.GoodsSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.goodssearchview',
	id: 'goodssearchview',
	resizable : false,
	multiSelect : true,
	closeAction : 'hide',
	loadMask : true,
	layout:'fit',
	requires:[
	    'Ext.ux.TreeCombox',
	    'WMS.store.common.StatusStr',
        'WMS.store.baseinfo.GoodsStr'
	],
	stores:[
		    'WMS.store.baseinfo.GoodsStr'
	],
	models:[
	        'WMS.model.baseinfo.GoodsMdl'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'货物编号',
					name:'goodsCode',
					labelWidth:90,
					width:250,
					length:50,
	        		vtypeText : '货物编号最多可输入50个字符',
        		    vtype: 'limitLen'
				},{
				    xtype:'textfield',
					fieldLabel:'品名',
					name:'goodsName',
					labelWidth:50,
					width:210,
					length:50,
	        		vtypeText : '品名最多可输入50个字符',
        		    vtype: 'limitLen'
				},{
					xtype:'treecombox',
					fieldLabel:'货物类别',
					name:'goodsCategoryName',
					labelWidth:75,
					width:235,
					displayField: 'text',
					editable: true,
					rootVisible: false,
					emptyText: "选择或输入类别",
					queryMode: 'remote', 
					store: Ext.create('WMS.store.systemservice.dictionary.GoodsPullDownStr',{
						params : {
							status : -1
						}
					})
				},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	}]	
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combobox',
				    fieldLabel:'供应商',
				    allowBlank:true,
				    name:'supplierId',
				    labelWidth : 90,
					emptyText: "--选择或输入--",
	        		editable: true,
	        		width : 250,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		displayField: 'supplierName',
		            valueField: 'supplierId',
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: -1
		            	},
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		    	}
				},{
				    xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    labelWidth :50,
				    editable: false,
				    width : 210,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
					border:false,
					width:8
				},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
	   			}]
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			},{
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			},{
				xtype : 'button',
				text : '导入',
				name : 'btn-import',
				iconCls: 'btn-import'
			},{
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			},{
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls: 'btn-openStatus'
			},{
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '货物编号', dataIndex: 'goodsCode', width:160,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:150,style :"text-align:center",align:'left'},
		    { text: '规格', dataIndex: 'specs', hidden:true},
		    { text: '父货物类别', dataIndex: 'parentGoodsCategoryName', hidden:true},
		    { text: '货物类别', dataIndex: 'goodsCategoryName', style :"text-align:center", width:100,  align:'left'},
		    { text: '供应商', dataIndex: 'supplierName', width:160, style :"text-align:center", align:'left'},
		    { text: '供应商编码', dataIndex: 'supplierCode',hidden: true},
		    { text: '价格', dataIndex: 'price', width:100, style :"text-align:center", align:'right'},
		    { text: '材质', dataIndex: 'material', hidden:true},
		    { text: '重量', dataIndex: 'weight', hidden:true},
		    { text: '保质期', dataIndex: 'shelfLife', width:100, style :"text-align:center", align:'right'},
		    { text: '最大库存量', dataIndex: 'maxStock', hidden:true},
		    { text: '最小库存量', dataIndex: 'minStock', hidden:true},
		    { text: '外包装数量', dataIndex: 'outerPackingQuantity', hidden:true},
		    { text: '内包装数量', dataIndex: 'innerPackingQuantity', hidden:true},
		    { text: '外包装货物体积', dataIndex: 'outerPackingVolume', hidden:true},
		    { text: '内包装货物体积', dataIndex: 'innerPackingVolume', hidden:true},
		    { text: '外包装货物重量', dataIndex: 'outerPackingWeight', hidden:true},
		    { text: '内包装货物重量', dataIndex: 'innerPackingWeight', hidden:true},
		    { text: '状态', dataIndex: 'displayStatus', width:80, style :"text-align:center",  align:'right'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的货物信息！',
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug739
			 */
			store:Ext.create('WMS.store.baseinfo.GoodsStr',{
				url: 'goods/searchGoodsPage.action'
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});
